/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback;

import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public interface CallbackHolder {
    public String getId();

    public ElementCallback getCallback();

    default public void runCallbacks(TemplateScreen screen) {
        CallbackHolder.runCallbacks(screen, this, this.getCallback());
    }

    public static void runCallbacks(TemplateScreen screen, CallbackHolder holder, @Nullable ElementCallback callback) {
        CallbackHolder.runCallbacks(screen, holder, callback, screen.getStorage());
    }

    public static void runCallbacks(TemplateScreen screen, CallbackHolder holder, @Nullable ElementCallback callback, VariableStorage variableStorage) {
        if (callback == null) {
            return;
        }
        try {
            callback.onPress(screen, holder, variableStorage);
        }
        catch (Throwable t) {
            callback.onError(holder, t);
        }
    }
}

