/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.menu;

import dan200.computercraft.core.apis.handles.ByteBufferChannel;
import dan200.computercraft.core.apis.transfer.TransferredFile;
import dan200.computercraft.core.apis.transfer.TransferredFiles;
import dan200.computercraft.core.computer.ComputerEvents;
import dan200.computercraft.core.util.StringUtil;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.upload.FileSlice;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInputState<T extends AbstractContainerMenu>
implements ServerInputHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerInputState.class);
    private final T owner;
    private final IntSet keysDown = new IntOpenHashSet(4);
    private int lastMouseX;
    private int lastMouseY;
    private int lastMouseDown = -1;
    private @Nullable UUID toUploadId;
    private @Nullable List<FileUpload> toUpload;

    public ServerInputState(T owner) {
        this.owner = owner;
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        this.keysDown.add(key);
        ComputerEvents.keyDown(((ComputerMenu)this.owner).getComputer(), key, repeat);
    }

    @Override
    public void keyUp(int key) {
        this.keysDown.remove(key);
        ComputerEvents.keyUp(((ComputerMenu)this.owner).getComputer(), key);
    }

    @Override
    public void charTyped(byte chr) {
        if (StringUtil.isTypableChar(chr)) {
            ComputerEvents.charTyped(((ComputerMenu)this.owner).getComputer(), chr);
        }
    }

    @Override
    public void paste(ByteBuffer contents) {
        if (contents.remaining() > 0 && ServerInputState.isValidClipboard(contents)) {
            ComputerEvents.paste(((ComputerMenu)this.owner).getComputer(), contents);
        }
    }

    private static boolean isValidClipboard(ByteBuffer buffer) {
        int max = buffer.limit();
        for (int i = buffer.remaining(); i < max; ++i) {
            if (StringUtil.isTypableChar(buffer.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = button;
        ComputerEvents.mouseClick(((ComputerMenu)this.owner).getComputer(), button, x, y);
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = -1;
        ComputerEvents.mouseUp(((ComputerMenu)this.owner).getComputer(), button, x, y);
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = button;
        ComputerEvents.mouseDrag(((ComputerMenu)this.owner).getComputer(), button, x, y);
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        ComputerEvents.mouseScroll(((ComputerMenu)this.owner).getComputer(), direction, x, y);
    }

    @Override
    public void terminate() {
        ((ComputerMenu)this.owner).getComputer().queueEvent("terminate");
    }

    @Override
    public void shutdown() {
        ((ComputerMenu)this.owner).getComputer().shutdown();
    }

    @Override
    public void turnOn() {
        ((ComputerMenu)this.owner).getComputer().turnOn();
    }

    @Override
    public void reboot() {
        ((ComputerMenu)this.owner).getComputer().reboot();
    }

    @Override
    public void startUpload(UUID uuid, List<FileUpload> files) {
        this.toUploadId = uuid;
        this.toUpload = files;
    }

    @Override
    public void continueUpload(UUID uploadId, List<FileSlice> slices) {
        if (this.toUploadId == null || this.toUpload == null || !this.toUploadId.equals(uploadId)) {
            LOG.warn("Invalid continueUpload call, skipping.");
            return;
        }
        for (FileSlice slice : slices) {
            slice.apply(this.toUpload);
        }
    }

    @Override
    public void finishUpload(ServerPlayer uploader, UUID uploadId) {
        if (this.toUploadId == null || this.toUpload == null || this.toUpload.isEmpty() || !this.toUploadId.equals(uploadId)) {
            LOG.warn("Invalid finishUpload call, skipping.");
            return;
        }
        ServerNetworking.sendToPlayer(this.finishUpload(uploader), uploader);
    }

    private UploadResultMessage finishUpload(ServerPlayer player) {
        ServerComputer computer = ((ComputerMenu)this.owner).getComputer();
        if (this.toUpload == null) {
            return UploadResultMessage.error(this.owner, UploadResult.COMPUTER_OFF_MSG);
        }
        for (FileUpload upload : this.toUpload) {
            if (upload.checksumMatches()) continue;
            LOG.warn("Checksum failed to match for {}.", (Object)upload.getName());
            return UploadResultMessage.error(this.owner, (Component)Component.translatable((String)"gui.computercraft.upload.failed.corrupted"));
        }
        computer.queueEvent("file_transfer", new Object[]{new TransferredFiles(this.toUpload.stream().map(x -> new TransferredFile(x.getName(), new ByteBufferChannel(x.getBytes()))).toList(), () -> {
            if (player.isAlive() && player.containerMenu == this.owner) {
                ServerNetworking.sendToPlayer(UploadResultMessage.consumed(this.owner), player);
            }
        })});
        return UploadResultMessage.queued(this.owner);
    }

    public void close() {
        ServerComputer computer = ((ComputerMenu)this.owner).getComputer();
        IntIterator keys = this.keysDown.iterator();
        while (keys.hasNext()) {
            ComputerEvents.keyUp(computer, keys.nextInt());
        }
        if (this.lastMouseDown != -1) {
            ComputerEvents.mouseUp(computer, this.lastMouseDown, this.lastMouseX, this.lastMouseY);
        }
        this.keysDown.clear();
        this.lastMouseDown = -1;
    }
}

