/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.detail.ForgeDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.methods.AbstractFluidMethods;
import dan200.computercraft.shared.util.ArgumentHelpers;
import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jspecify.annotations.Nullable;

public final class FluidMethods
extends AbstractFluidMethods<IFluidHandler> {
    @Override
    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> tanks(IFluidHandler fluids) {
        HashMap result = new HashMap();
        int size = fluids.getTanks();
        for (int i = 0; i < size; ++i) {
            FluidStack stack = fluids.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            result.put(i + 1, ForgeDetailRegistries.FLUID_STACK.getBasicDetails(stack));
        }
        return result;
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pushFluid(IFluidHandler from, IComputerAccess computer, String toName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        Fluid fluid = fluidName.isPresent() ? (Fluid)ArgumentHelpers.getRegistryEntry(fluidName.get(), "fluid", BuiltInRegistries.FLUID) : null;
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IFluidHandler to = FluidMethods.extractHandler(location);
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an tank");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        if (actualLimit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        return fluid == null ? FluidMethods.moveFluid(from, actualLimit, to) : FluidMethods.moveFluid(from, new FluidStack(fluid, actualLimit), to);
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pullFluid(IFluidHandler to, IComputerAccess computer, String fromName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        Fluid fluid = fluidName.isPresent() ? (Fluid)ArgumentHelpers.getRegistryEntry(fluidName.get(), "fluid", BuiltInRegistries.FLUID) : null;
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IFluidHandler from = FluidMethods.extractHandler(location);
        if (from == null) {
            throw new LuaException("Target '" + fromName + "' is not an tank");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        if (actualLimit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        return fluid == null ? FluidMethods.moveFluid(from, actualLimit, to) : FluidMethods.moveFluid(from, new FluidStack(fluid, actualLimit), to);
    }

    private static @Nullable IFluidHandler extractHandler(IPeripheral peripheral) {
        Direction direction;
        Object object = peripheral.getTarget();
        if (peripheral instanceof GenericPeripheral) {
            GenericPeripheral sided = (GenericPeripheral)peripheral;
            v0 = sided.side();
        } else {
            v0 = direction = null;
        }
        if (object instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)object;
            if (blockEntity.isRemoved()) {
                return null;
            }
            Level level = blockEntity.getLevel();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            IFluidHandler result = (IFluidHandler)CapabilityUtil.getCapability(serverLevel, Capabilities.FluidHandler.BLOCK, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, direction);
            if (result != null) {
                return result;
            }
        }
        if (object instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)object;
            return handler;
        }
        return null;
    }

    private static int moveFluid(IFluidHandler from, int limit, IFluidHandler to) {
        return FluidMethods.moveFluid(from, from.drain(limit, IFluidHandler.FluidAction.SIMULATE), limit, to);
    }

    private static int moveFluid(IFluidHandler from, FluidStack fluid, IFluidHandler to) {
        return FluidMethods.moveFluid(from, from.drain(fluid, IFluidHandler.FluidAction.SIMULATE), fluid.getAmount(), to);
    }

    private static int moveFluid(IFluidHandler from, FluidStack extracted, int limit, IFluidHandler to) {
        if (extracted.getAmount() <= 0) {
            return 0;
        }
        extracted = extracted.copy();
        extracted.setAmount(Math.min(extracted.getAmount(), limit));
        int inserted = to.fill(extracted.copy(), IFluidHandler.FluidAction.EXECUTE);
        if (inserted <= 0) {
            return 0;
        }
        extracted.setAmount(inserted);
        from.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
        return inserted;
    }
}

