// priority: 9999

const ingot_to_dust = [
  ["ftbmaterials:tin_ingot", "ftbmaterials:tin_dust"],
  ["ftbmaterials:invar_ingot", "ftbmaterials:invar_dust"],
  ["ftbmaterials:bronze_ingot", "ftbmaterials:bronze_dust"],
  ["ftbmaterials:lead_ingot", "ftbmaterials:lead_dust"],
  ["ftbmaterials:steel_ingot", "ftbmaterials:steel_dust"],
  ["ftbmaterials:electrum_ingot", "ftbmaterials:electrum_dust"],
  ["minecraft:copper_ingot", "ftbmaterials:copper_dust"],
  ["ftbmaterials:uranium_ingot", "ftbmaterials:uranium_dust"],
  ["ftbmaterials:nickel_ingot", "ftbmaterials:nickel_dust"],
  ["ftbmaterials:titanium_ingot", "ftbmaterials:titanium_dust"],
  ["ftbmaterials:tungsten_ingot", "ftbmaterials:tungsten_dust"],
  ["ftbmaterials:iridium_ingot", "ftbmaterials:iridium_dust"],
  ["ftbmaterials:antimony_ingot", "ftbmaterials:antimony_dust"],
  ["ftbmaterials:silver_ingot", "ftbmaterials:silver_dust"],
  ["ftbmaterials:osmium_ingot", "ftbmaterials:osmium_dust"],
];

const ores_to_raw_mi = [
  "lead",
  "nickel",
  "osmium",
  "tin",
  "antimony",
  "iridium",
  "platinum"
];

const materials = [
  "aluminum",
  "bronze",
  "diamond",
  "electrum",
  "gold",
  "iron",
  "steel",
  "titanium",
  "platinum",
  "invar",
  "nickel",
  "silver",
  "tin",
  "zinc",
  "iridium",
  "tungsten",
  "antimony",
];

const rodMaterials = [
  "aluminum",
  "bronze",
  "steel",
  "iron",
  "titanium",
  "invar",
  "tin",
];

const nuggetCrafts = [
  "ftbmaterials:tin_nugget",
  "ftbmaterials:steel_nugget",
  "ftbmaterials:refined_glowstone_nugget",
  "ftbmaterials:silver_nugget",
  "ftbmaterials:osmium_nugget",
  "ftbmaterials:lead_nugget",
  "ftbmaterials:uranium_nugget",
  "ftbmaterials:zinc_nugget",
  "ftbmaterials:antimony_nugget",
];


ServerEvents.recipes((event) => {

  function eio_crushing(input, output) {
    event.custom({
      "type": "enderio:sag_milling",
      "bonus": "none",
      "energy": 2400,
      "input": {
        "tag": input
      },
      "outputs": [
        {
          "item": {
            "count": 1,
            "id": output
          }
        }
      ]
    }).id(`ftb:eio_crushing_${input.split(':').join('_')}`);
  }

  function mi_crush(input,output,count){
    event
    .custom({
      type: "modern_industrialization:macerator",
      duration: 100,
      eu: 2,
      item_inputs: [
        {
          amount: 1,
          tag: input,
        },
      ],
      item_outputs: [
        {
          amount: count,
          item: output,
        },
      ],
    })
    .id(`ftb:mi_crushing${input.split(':').join('_')}`);
  }

  function aa_crushing(input, output) {
    event.custom({
      "type": "actuallyadditions:crushing",
      "ingredient": {
        "item": input
      },
      "result": [
        {
          "result": {
            "count": 1,
            "id": output
          }
        }
      ]
    }).id(`ftb:aa_crushing_${input.split(':').join('_')}`);
  }
  

  nuggetCrafts.forEach((nugget) => {
    event
      .shapeless(Item.of(nugget, 9), [nugget.replace("_nugget", "_ingot")])
      .id(`ftb:ingot_to_nugget_${nugget.replace("ftbmaterials:", "")}`);
    event
      .shaped(nugget.replace("_nugget", "_ingot"), ["NNN", "NNN", "NNN"], {
        N: nugget,
      })
      .id(`ftb:nugget_to_ingot_${nugget.replace("ftbmaterials:", "")}`);
  });

  event
    .shapeless(Item.of("ftbmaterials:netherite_nugget", 9), [
      "minecraft:netherite_ingot",
    ])
    .id(`ftb:ingot_to_nugget_netherite`);
  event
    .shaped("minecraft:netherite_ingot", ["NNN", "NNN", "NNN"], {
      N: "ftbmaterials:netherite_nugget",
    })
    .id(`ftb:nugget_to_ingot_netherite`);

  rodMaterials.forEach((rodmaterial) => {
    // Replace MI Rods
    const rodAllInput = `modern_industrialization:${rodmaterial}_rod`;
    const rodAllOutput = `ftbmaterials:${rodmaterial}_rod`;
    event.replaceOutput(
      { mod: "modern_industrialization" },
      rodAllInput,
      rodAllOutput
    );
  });

  rodMaterials.forEach((rodmaterial) => {
    // Replace MI Rods
    if (rodmaterial === "aluminum") return;
    const rodAllInput = `immersiveengineering:stick_${rodmaterial}`;
    const rodAllOutput = `ftbmaterials:${rodmaterial}_rod`;
    event.replaceOutput(
      { mod: "immersiveengineering" },
      rodAllInput,
      rodAllOutput
    );
  });

  materials.forEach((material) => {
    // Replace MI Ingots
    const ingotAllInput = `modern_industrialization:${material}_ingot`;
    const ingotAllOutput = `ftbmaterials:${material}_ingot`;
    event.replaceOutput(
      { mod: "modern_industrialization" },
      ingotAllInput,
      ingotAllOutput
    );

    // Replace Mek Ingots
    const ingotAllMekInput = `mekanism:${material}_ingot`;
    const ingotAllMekOutput = `ftbmaterials:ingot_${material}`;
    event.replaceOutput(
      { mod: "modern_industrialization" },
      ingotAllMekInput,
      ingotAllMekOutput
    );

    // Replace Gears
    const gearInput = `modern_industrialization:${material}_gear`;
    const gearOutput = `ftbmaterials:${material}_gear`;
    event.replaceOutput(
      { mod: "modern_industrialization" },
      gearInput,
      gearOutput
    );

    // Replace Plates
    const plateInput = `modern_industrialization:${material}_plate`;
    const plateOutput = `ftbmaterials:${material}_plate`;
    event.replaceOutput(
      { mod: "modern_industrialization" },
      plateInput,
      plateOutput
    );

    // Replace Rods
    const rodInput = `modern_industrialization:${material}_plate`;
    const rodOutput = `ftbmaterials:${material}_plate`;
    event.replaceInput(
      { mod: "modern_industrialization" },
      rodInput,
      rodOutput
    );

    // Replace Nuggets
    const nuggetInput = `modern_industrialization:${material}_nugget`;
    const nuggetOutput = `ftbmaterials:${material}_nugget`;
    event.replaceOutput(
      { mod: "modern_industrialization" },
      nuggetInput,
      nuggetOutput
    );
    // Replace Dust
    const dustInput = `modern_industrialization:${material}_dust`;
    const dustOutput = `ftbmaterials:${material}_dust`;
    event.replaceOutput(
      { mod: "modern_industrialization" },
      dustInput,
      dustOutput
    );
  });

  event.replaceOutput(
    { mod: "modern_industrialization" },
    "modern_industrialization:bauxite_dust",
    "ftbmaterials:bauxite_dust"
  );

  event.replaceOutput(
    { mod: "modern_industrialization" },
    "mekanism:dust_copper",
    "ftbmaterials:copper_dust"
  );

  event.replaceOutput(
    { mod: "enderio" },
    "enderio:iron_gear",
    "ftbmaterials:iron_gear"
  );

  event
    .custom({
      type: "modern_industrialization:macerator",
      duration: 100,
      eu: 2,
      item_inputs: [
        {
          amount: 1,
          tag: "c:ingots/silver",
        },
      ],
      item_outputs: [
        {
          amount: 1,
          item: "ftbmaterials:silver_dust",
        },
      ],
    })
    .id("modern_industrialization:macerator_silver_dust");

    ingot_to_dust.forEach(pair => {
      const [input, output] = pair;
      aa_crushing(input, output);
      eio_crushing(`c:ingots/${input.split(":")[1].split("_")[0]}`, output);
    });

    ores_to_raw_mi.forEach(ore => {
      mi_crush(`c:ores/${ore}`, `ftbmaterials:${ore}_raw_ore`, 3);
      mi_crush(`c:raw_materials/${ore}`, `ftbmaterials:${ore}_dust`, 2);
    });

    //Adding proper recipes for our Custom Ruby Gem
    mi_crush("c:gems/ruby", "modern_industrialization:ruby_dust", 1);
    aa_crushing("ftbevolution:ruby_gem", "modern_industrialization:ruby_dust");
    eio_crushing("c:gems/ruby", "modern_industrialization:ruby_dust");
    //Enriching Dust to Gem
    event.custom({"type": "mekanism:enriching", "input": {"count": 1, "tag": "c:dusts/ruby"}, "output": {"count": 1, "id": "ftbevolution:ruby_gem"}}).id("ftbevolution:mekanism/enriching/ruby_gem");
    //Implosion Compressing to Gem
    event.custom({
      "type": "modern_industrialization:implosion_compressor",
      "eu": 1,
      "duration": 10,
      "item_inputs": [
        {
          "tag": "c:dusts/ruby",
          "amount": 1
        },
        {
          "item": "modern_industrialization:industrial_tnt",
          "amount": 1
        }
      ],
      "item_outputs": {
        "item": "ftbevolution:ruby_gem",
        "amount": 1
      }
    }).id("ftbevolution:modern_industrialization/implosion_compressor/ruby_gem");
    
});
