// priority: 1003

// Configuration for resources to remove, each entry specifies types to target
// Example: [{resourceNames: "electrum", ignoreTags: ["blocks"]}]
//
// resourceNames: List of resource names - required (can be an array of strings)
// ignoreTags: Array of types to exclude - optional
// deniedTags: Array of types to specifically remove - optional
const resourceRemovalConfigs = [
  {
    resourceNames: ["graphite", "lumium", "apatite", "resonating_ore", "dimensional_shard"],
  },
  {
    resourceNames: [
      "redstone", "copper", "gold", "iron", "lead", "electrum", "constantan", "nickel",
      "osmium", "silver", "tin", "uranium", "zinc", "fluorite", "emerald", "lapis_lazuli",
      "bauxite", "monazite"
    ],
    deniedTags: ["end_ore", "nether_ore", "wire", "gem", "blade"],
  },
  {
    resourceNames: ["bronze", "invar", "netherite", "obsidian", "refined_glowstone", "signalum", "diamond"],
    deniedTags: ["wire"],
  },
  {
    resourceNames: ["obsidian"],
    deniedTags: ["gear", "rod", "plate"],
  },
  {
    resourceNames: ["diamond"],
    deniedTags: ["nether_ore"],
  },
  {
    resourceNames: ["bronze"],
    deniedTags: ["blade"],
  },
  {
    resourceNames: ["quartz"],
    ignoreTags: ["dust"],
  },
  {
    resourceNames: ["sulfur", "diamond"],
    deniedTags: ["shard", "clump", "crystal", "dirty_dust", "nugget"],
  },
  {
    resourceNames: ["refined_glowstone", "uranium"],
    deniedTags: ["gear"],
  },
  {
    resourceNames: [
      "bronze", "diamond", "gold", "iron", "invar", "lead", "netherite",
      "osmium", "refined_glowstone", "steel", "tin", "uranium"
    ],
    deniedTags: ["rod"],
  },
  {
    resourceNames: ["refined_glowstone"],
    deniedTags: ["plate"],
  },
];

// Possible types for items and blocks
const itemTagTypes = ["nugget", "rod", "wire", "plate", "gem", "ingot", "dust", "gear", "raw_ore", "dirty_dust", "shard", "clump", "blade", "crystal"];
const blockTagTypes = ["block", "raw_block", "stone_ore", "deepslate_ore", "end_ore", "nether_ore"];

const tagCategories = [
  { category: "item", types: itemTagTypes },
  { category: "block", types: blockTagTypes },
];

tagCategories.forEach((tagCategory) => {
  ServerEvents.tags(tagCategory.category, (event) => {
    resourceRemovalConfigs.forEach((resourceConfig) => {
      resourceConfig.resourceNames.forEach((resourceName) => {
        const baseResourceID = `ftbmaterials:${resourceName}_`;
        
        if (resourceConfig.deniedTags) {
          // Specifically handle denied tags for this resource
          resourceConfig.deniedTags.forEach((deniedTag) => {
            event.removeAllTagsFrom(baseResourceID + deniedTag);
            event.add("c:hidden_from_recipe_viewers", baseResourceID + deniedTag);
            //console.log(`Removed ${baseResourceID + deniedTag}`);
          });
        } else {
          // Apply to all tags except those listed in ignoreTags
          tagCategory.types.forEach((tagType) => {
            if (!resourceConfig.ignoreTags || !resourceConfig.ignoreTags.includes(tagType)) {
              event.removeAllTagsFrom(baseResourceID + tagType);
              event.add("c:hidden_from_recipe_viewers", baseResourceID + tagType);
              //console.log(`Removed ${baseResourceID + tagType}`);
            }
          });
        }
      });
    });
  });
});
