// priority: 1002

const magicMobs = [
  "ars_nouveau:wilden_boss",
  "minecraft:evoker",
  "minecraft:witch",
  "irons_spellbooks:catacombs_zombie",
  "irons_spellbooks:apothecarist",
  "irons_spellbooks:archevoker",
  "irons_spellbooks:citadel_keeper",
  "irons_spellbooks:cryomancer",
  "irons_spellbooks:cultist",
  "irons_spellbooks:dead_king",
  "irons_spellbooks:necromancer",
  "irons_spellbooks:priest",
  "irons_spellbooks:pyromancer",
];

const jeiBlacklist = [
  "ae2:facade",
  "functionalstorage:armory_cabinet",
  "mekanism:creative_chemical_tank",
  "mekanism:creative_fluid_tank",
  "productivebees:stone_chip",
  "productivebees:wood_chip",
  "forbidden_arcanus:soul_binding_crystal"
];

const yieldBlacklist = [
  "#forge:coals",
  "#c:coals",
  "#neoforge:coals",
  "laserio:logic_chip",
  "#pneumaticcraft:plastic_sheets",
  "stevescarts:component_refined_hardener",
  "#forge:rods",
  "#forge:rods/all_metal",
  "#forge:wires",
  "#c:rods",
  "#c:rods/all_metal",
  "#c:wires",
  "#c:ingots",
  "#c:gems",
  "#c:storage_blocks",
  "#c:dusts",
  "#neoforge:rods",
  "#neoforge:rods/all_metal",
  "#neoforge:wires",
  "stevescarts:component_galgadorian_metal",
];

const arcaneOres = [
  "malum:brilliant_stone",
  "malum:cthonic_gold_ore",
  "malum:natural_quartz_ore",
  "malum:deepslate_quartz_ore",
  "malum:soulstone_ore",
  "malum:blazing_quartz_ore"

]
const miHammers = [
  "justhammers:gold_reinforced_hammer",
  "justhammers:diamond_reinforced_hammer",
  "justhammers:netherite_reinforced_hammer",
  "justhammers:iron_reinforced_impact_hammer",
  "justhammers:gold_reinforced_impact_hammer",
  "justhammers:diamond_reinforced_impact_hammer",
  "justhammers:netherite_reinforced_impact_hammer",
  "justhammers:iron_destructor_hammer",
  "justhammers:gold_destructor_hammer",
  "justhammers:diamond_destructor_hammer",
  "justhammers:netherite_destructor_hammer",
  "justhammers:iron_reinforced_hammer",
  "justhammers:netherite_impact_hammer",
  "justhammers:diamond_impact_hammer",
  "justhammers:gold_impact_hammer",
  "justhammers:diamond_hammer",
  "justhammers:netherite_hammer",
  "justhammers:iron_impact_hammer",
  "justhammers:gold_hammer",
  "justhammers:iron_hammer",
];

const arsBlacklist = [
  "integratedtunnels:part_interface_item",
  "integratedtunnels:part_interface_filter_item",
  "integratedtunnels:part_importer_item",
  "integratedtunnels:part_exporter_item",
  "integratedtunnels:part_importer_world_item",
  "integratedtunnels:part_exporter_world_item",
  "chipped:botanist_workbench",
  "chipped:glassblower",
  "chipped:carpenters_table",
  "chipped:loom_table",
  "chipped:mason_table",
  "chipped:alchemy_bench",
  "chipped:tinkering_table",
  "integrateddynamics:bucket_liquid_chorus",
  "integrateddynamics:bucket_menril_resin",
  "justdirethings:polymorphic_fluid_bucket",
  "justdirethings:portal_fluid_bucket",
  "justdirethings:time_fluid_bucket",
  "justdirethings:unstable_portal_fluid_bucket",
  "justdirethings:unrefined_t2_fluid_bucket",
  "justdirethings:refined_t2_fluid_bucket",
  "justdirethings:unrefined_t3_fluid_bucket",
  "mekanism:steam_bucket",
  "mekanism:heavy_water_bucket",
  "mekanism:nutritional_paste_bucket",
  "mekanismgenerators:bioethanol_bucket",
  "mekanismgenerators:deuterium_bucket",
  "mekanismgenerators:fusion_fuel_bucket",
  "mekanismgenerators:tritium_bucket",
  "sophisticatedcore:xp_bucket",
  "mekanism:hydrogen_chloride_bucket",
  "mekanism:hydrofluoric_acid_bucket",
  "mekanism:uranium_oxide_bucket",
  "mekanism:uranium_hexafluoride_bucket",
  "mekanism:ethene_bucket",
  "mekanism:sodium_bucket",
  "mekanism:superheated_sodium_bucket",
  "mekanism:brine_bucket",
  "mekanism:lithium_bucket",
  "justdirethings:refined_t3_fluid_bucket",
  "justdirethings:unrefined_t4_fluid_bucket",
  "justdirethings:refined_t4_fluid_bucket",
  "mekanism:hydrogen_bucket",
  "mekanism:oxygen_bucket",
  "mekanism:chlorine_bucket",
  "mekanism:sulfur_dioxide_bucket",
  "mekanism:sulfur_trioxide_bucket",
  "mekanism:sulfuric_acid_bucket",
  "enderio:nutrient_distillation_bucket",
  "enderio:dew_of_the_void_bucket",
  "enderio:vapor_of_levity_bucket",
  "enderio:hootch_bucket",
  "enderio:rocket_fuel_bucket",
  "enderio:fire_water_bucket",
  "enderio:xp_juice_bucket",
  "enderio:liquid_sunshine_bucket",
  "enderio:cloud_seed_bucket",
  "enderio:cloud_seed_concentrated_bucket",
];

// const removeBoonDrops = [
//   "ftbmaterials:resonating_ore_stone_ore",
//   "ftbmaterials:dimensional_shard_stone_ore",
//   "modern_industrialization:bauxite_ore",
//   "modern_industrialization:antimony_ore",
//   "occultism:silver_ore",
//   "mekanism:osmium_ore",
//   "mekanism:tin_ore",
//   "mekanism:uranium_ore",
//   "mekanism:lead_ore",
//   "modern_industrialization:monazite_ore",
//   "powah:uraninite_block",
//   "xycraft_world:aluminum_ore_stone",
//   "ftbmaterials:sulfur_stone_ore",
//   "ftbmaterials:fluorite_stone_ore",
//   "modern_industrialization:tungsten_ore",
//   "modern_industrialization:titanium_ore",
//   "modern_industrialization:quartz_ore",
//   "modern_industrialization:nickel_ore",
//   "modern_industrialization:platinum_ore",
//   "modern_industrialization:iridium_ore",
//   "ftbmaterials:fluorite_stone_ore",
//   "ftbmaterials:dimensional_shard_stone_ore",
//   "ftbmaterials:resonating_ore_stone_ore",
//   "ftbmaterials:zinc_stone_ore",
//   "mekanism:osmium_ore",
//   "ftbmaterials:platinum_stone_ore",
//   "modern_industrialization:platinum_ore",
//   "ftbmaterials:titanium_stone_ore",
//   "mekanism:tin_ore",
//   "mekanism:uranium_ore",
//   "mekanism:lead_ore",
//   "modern_industrialization:titanium_ore",
//   "modern_industrialization:quartz_ore",
//   "modern_industrialization:tungsten_ore",
//   "modern_industrialization:nickel_ore",
//   "modern_industrialization:monazite_ore",
//   "modern_industrialization:iridium_ore",
//   "modern_industrialization:bauxite_ore",
//   "modern_industrialization:antimony_ore",
//   "occultism:silver_ore",
//   "minecraft:iron_chestplate",
//   "mekanism:dust_sulfur"
// ];

const addLawnmowerable = [
  "projectvibrantjourneys:glowing_blue_fungus",
  "projectvibrantjourneys:white_bark_mushroom",
  "projectvibrantjourneys:orange_bark_mushroom",
  "projectvibrantjourneys:light_brown_bark_mushroom",
  "projectvibrantjourneys:bark_mushroom",
  "projectvibrantjourneys:cattail",
  "projectvibrantjourneys:sea_oats",
  "projectvibrantjourneys:beach_grass",
  "projectvibrantjourneys:watergrass",
  "projectvibrantjourneys:sandy_sprouts",
  "projectvibrantjourneys:reeds",
  "projectvibrantjourneys:small_cactus",
  "projectvibrantjourneys:short_grass",
  "projectvibrantjourneys:blue_wildflowers",
  "projectvibrantjourneys:yellow_wildflowers",
  "projectvibrantjourneys:orange_wildflowers",
  "projectvibrantjourneys:purple_wildflowers",
  "projectvibrantjourneys:white_wildflowers",
  "projectvibrantjourneys:mixed_wildflowers",
];

const stellaBlacklist = [
  "#c:ingots",
  "#c:nuggets",
  "#c:storage_blocks",
  "#c:ores",
  "actuallyadditions:coffee_cup"
];

const vanillaPlanks = [
  "minecraft:oak_planks",
  "minecraft:spruce_planks",
  "minecraft:birch_planks",
  "minecraft:jungle_planks",
  "minecraft:acacia_planks",
  "minecraft:dark_oak_planks",
  "minecraft:mangrove_planks",
  "minecraft:cherry_planks",
  "minecraft:bamboo_planks",
  "minecraft:crimson_planks",
  "minecraft:warped_planks",
  "ars_nouveau:archwood_planks",
  "paganbless:black_thorn_planks",
];

const productive_planks = [
  "productivetrees:cacao_planks",
  "productivetrees:candlenut_planks",
  "productivetrees:carob_planks",
  "productivetrees:cashew_planks",
  "productivetrees:cave_dweller_planks",
  "productivetrees:cedar_planks",
  "productivetrees:cempedak_planks",
  "productivetrees:ceylon_ebony_planks",
  "productivetrees:cherry_plum_planks",
  "productivetrees:alder_planks",
  "productivetrees:allspice_planks",
  "productivetrees:almond_planks",
  "productivetrees:apricot_planks",
  "productivetrees:aquilaria_planks",
  "productivetrees:asai_palm_planks",
  "productivetrees:ash_planks",
  "productivetrees:aspen_planks",
  "productivetrees:avocado_planks",
  "productivetrees:balsa_planks",
  "productivetrees:balsam_fir_planks",
  "productivetrees:banana_planks",
  "productivetrees:beech_planks",
  "productivetrees:beliy_naliv_apple_planks",
  "productivetrees:blackthorn_planks",
  "productivetrees:black_cherry_planks",
  "productivetrees:black_ember_planks",
  "productivetrees:black_locust_planks",
  "productivetrees:blue_mahoe_planks",
  "productivetrees:boxwood_planks",
  "productivetrees:brazilwood_planks",
  "productivetrees:brazil_nut_planks",
  "productivetrees:breadfruit_planks",
  "productivetrees:brown_amber_planks",
  "productivetrees:buddhas_hand_planks",
  "productivetrees:bull_pine_planks",
  "productivetrees:butternut_planks",
  "productivetrees:cinnamon_planks",
  "productivetrees:citron_planks",
  "productivetrees:clove_planks",
  "productivetrees:cocobolo_planks",
  "productivetrees:coconut_planks",
  "productivetrees:coffea_planks",
  "productivetrees:copoazu_planks",
  "productivetrees:cork_oak_planks",
  "productivetrees:cultivated_pear_planks",
  "productivetrees:date_palm_planks",
  "productivetrees:dogwood_planks",
  "productivetrees:douglas_fir_planks",
  "productivetrees:elderberry_planks",
  "productivetrees:elm_planks",
  "productivetrees:european_larch_planks",
  "productivetrees:finger_lime_planks",
  "productivetrees:firecracker_planks",
  "productivetrees:flickering_sun_planks",
  "productivetrees:flowering_crabapple_planks",
  "productivetrees:foggy_blast_planks",
  "productivetrees:ginkgo_planks",
  "productivetrees:golden_delicious_apple_planks",
  "productivetrees:grandidiers_baobab_planks",
  "productivetrees:granny_smith_apple_planks",
  "productivetrees:grapefruit_planks",
  "productivetrees:great_sallow_planks",
  "productivetrees:greenheart_planks",
  "productivetrees:hawthorn_planks",
  "productivetrees:hazel_planks",
  "productivetrees:holly_planks",
  "productivetrees:hornbeam_planks",
  "productivetrees:ipe_planks",
  "productivetrees:iroko_planks",
  "productivetrees:jackfruit_planks",
  "productivetrees:juniper_planks",
  "productivetrees:kapok_planks",
  "productivetrees:key_lime_planks",
  "productivetrees:kumquat_planks",
  "productivetrees:lawson_cypress_planks",
  "productivetrees:lemon_planks",
  "productivetrees:lime_planks",
  "productivetrees:loblolly_pine_planks",
  "productivetrees:logwood_planks",
  "productivetrees:mahogany_planks",
  "productivetrees:mandarin_planks",
  "productivetrees:mango_planks",
  "productivetrees:monkey_puzzle_planks",
  "productivetrees:myrtle_ebony_planks",
  "productivetrees:nectarine_planks",
  "productivetrees:night_fuchsia_planks",
  "productivetrees:nutmeg_planks",
  "productivetrees:old_fustic_planks",
  "productivetrees:olive_planks",
  "productivetrees:orange_planks",
  "productivetrees:osage_orange_planks",
  "productivetrees:padauk_planks",
  "productivetrees:pandanus_planks",
  "productivetrees:papaya_planks",
  "productivetrees:peach_planks",
  "productivetrees:pecan_planks",
  "productivetrees:persimmon_planks",
  "productivetrees:pink_ivory_planks",
  "productivetrees:pistachio_planks",
  "productivetrees:plantain_planks",
  "productivetrees:plum_planks",
  "productivetrees:pomegranate_planks",
  "productivetrees:pomelo_planks",
  "productivetrees:prairie_crabapple_planks",
  "productivetrees:purpleheart_planks",
  "productivetrees:purple_crepe_myrtle_planks",
  "productivetrees:purple_spiral_planks",
  "productivetrees:rainbow_gum_planks",
  "productivetrees:red_banana_planks",
  "productivetrees:red_delicious_apple_planks",
  "productivetrees:red_maple_planks",
  "productivetrees:rippling_willow_planks",
  "productivetrees:rosewood_planks",
  "productivetrees:rose_gum_planks",
  "productivetrees:rowan_planks",
  "productivetrees:rubber_tree_planks",
  "productivetrees:salak_planks",
  "productivetrees:sandalwood_planks",
  "productivetrees:sand_pear_planks",
  "productivetrees:satsuma_planks",
  "productivetrees:sequoia_planks",
  "productivetrees:silver_fir_planks",
  "productivetrees:silver_lime_planks",
  "productivetrees:slimy_delight_planks",
  "productivetrees:socotra_dragon_planks",
  "productivetrees:soul_tree_planks",
  "productivetrees:soursop_planks",
  "productivetrees:sour_cherry_planks",
  "productivetrees:sparkle_cherry_planks",
  "productivetrees:star_anise_planks",
  "productivetrees:star_fruit_planks",
  "productivetrees:sugar_apple_planks",
  "productivetrees:sugar_maple_planks",
  "productivetrees:swamp_gum_planks",
  "productivetrees:sweetgum_planks",
  "productivetrees:sweet_chestnut_planks",
  "productivetrees:sweet_crabapple_planks",
  "productivetrees:sycamore_fig_planks",
  "productivetrees:tangerine_planks",
  "productivetrees:teak_planks",
  "productivetrees:thunder_bolt_planks",
  "productivetrees:time_traveller_planks",
  "productivetrees:blue_yonder_planks",
  "productivetrees:walnut_planks",
  "productivetrees:water_wonder_planks",
  "productivetrees:wenge_planks",
  "productivetrees:western_hemlock_planks",
  "productivetrees:whitebeam_planks",
  "productivetrees:white_poplar_planks",
  "productivetrees:white_willow_planks",
  "productivetrees:wild_cherry_planks",
  "productivetrees:yellow_meranti_planks",
  "productivetrees:yew_planks",
  "productivetrees:zebrano_planks",
  "productivetrees:zebrano_planks",
];

const bwg_planks = [
  "biomeswevegone:aspen_planks",
  "biomeswevegone:baobab_planks",
  "biomeswevegone:blue_enchanted_planks",
  "biomeswevegone:cika_planks",
  "biomeswevegone:cypress_planks",
  "biomeswevegone:ebony_planks",
  "biomeswevegone:fir_planks",
  "biomeswevegone:florus_planks",
  "biomeswevegone:green_enchanted_planks",
  "biomeswevegone:holly_planks",
  "biomeswevegone:ironwood_planks",
  "biomeswevegone:jacaranda_planks",
  "biomeswevegone:mahogany_planks",
  "biomeswevegone:maple_planks",
  "biomeswevegone:palm_planks",
  "biomeswevegone:pine_planks",
  "biomeswevegone:rainbow_eucalyptus_planks",
  "biomeswevegone:redwood_planks",
  "biomeswevegone:sakura_planks",
  "biomeswevegone:skyris_planks",
  "biomeswevegone:white_mangrove_planks",
  "biomeswevegone:willow_planks",
  "biomeswevegone:witch_hazel_planks",
  "biomeswevegone:zelkova_planks",
];

const rechiseled_acacia = [
  "rechiseled:acacia_planks_beams",
  "rechiseled:acacia_planks_beams_connecting",
  "rechiseled:acacia_planks_brick_pattern",
  "rechiseled:acacia_planks_brick_pattern_connecting",
  "rechiseled:acacia_planks_brick_paving",
  "rechiseled:acacia_planks_brick_paving_connecting",
  "rechiseled:acacia_planks_bricks",
  "rechiseled:acacia_planks_bricks_connecting",
  "rechiseled:acacia_planks_crate",
  "rechiseled:acacia_planks_crate_connecting",
  "rechiseled:acacia_planks_diagonal_stripes",
  "rechiseled:acacia_planks_diagonal_stripes_connecting",
  "rechiseled:acacia_planks_diagonal_tiles",
  "rechiseled:acacia_planks_diagonal_tiles_connecting",
  "rechiseled:acacia_planks_dotted",
  "rechiseled:acacia_planks_dotted_connecting",
  "rechiseled:acacia_planks_flooring",
  "rechiseled:acacia_planks_flooring_connecting",
  "rechiseled:acacia_planks_large_tiles",
  "rechiseled:acacia_planks_large_tiles_connecting",
  "rechiseled:acacia_planks_mosaic",
  "rechiseled:acacia_planks_pattern",
  "rechiseled:acacia_planks_pattern_connecting",
  "rechiseled:acacia_planks_rotated_bricks",
  "rechiseled:acacia_planks_rotated_bricks_connecting",
  "rechiseled:acacia_planks_small_bricks",
  "rechiseled:acacia_planks_small_bricks_connecting",
  "rechiseled:acacia_planks_small_tiles",
  "rechiseled:acacia_planks_small_tiles_connecting",
  "rechiseled:acacia_planks_squares",
  "rechiseled:acacia_planks_squares_connecting",
  "rechiseled:acacia_planks_tiles",
  "rechiseled:acacia_planks_tiles_connecting",
  "rechiseled:acacia_planks_wavy",
  "rechiseled:acacia_planks_wavy_connecting",
  "rechiseled:acacia_planks_woven",
  "rechiseled:acacia_planks_woven_connecting",
];
const rechiseled_bamboo = [
  "rechiseled:bamboo_planks_beams",
  "rechiseled:bamboo_planks_beams_connecting",
  "rechiseled:bamboo_planks_brick_pattern",
  "rechiseled:bamboo_planks_brick_pattern_connecting",
  "rechiseled:bamboo_planks_brick_paving",
  "rechiseled:bamboo_planks_brick_paving_connecting",
  "rechiseled:bamboo_planks_bricks",
  "rechiseled:bamboo_planks_bricks_connecting",
  "rechiseled:bamboo_planks_crate",
  "rechiseled:bamboo_planks_crate_connecting",
  "rechiseled:bamboo_planks_diagonal_stripes",
  "rechiseled:bamboo_planks_diagonal_stripes_connecting",
  "rechiseled:bamboo_planks_diagonal_tiles",
  "rechiseled:bamboo_planks_diagonal_tiles_connecting",
  "rechiseled:bamboo_planks_dotted",
  "rechiseled:bamboo_planks_dotted_connecting",
  "rechiseled:bamboo_planks_flooring",
  "rechiseled:bamboo_planks_flooring_connecting",
  "rechiseled:bamboo_planks_large_tiles",
  "rechiseled:bamboo_planks_large_tiles_connecting",
  "rechiseled:bamboo_planks_mosaic",
  "rechiseled:bamboo_planks_pattern",
  "rechiseled:bamboo_planks_pattern_connecting",
  "rechiseled:bamboo_planks_rotated_bricks",
  "rechiseled:bamboo_planks_rotated_bricks_connecting",
  "rechiseled:bamboo_planks_small_bricks",
  "rechiseled:bamboo_planks_small_bricks_connecting",
  "rechiseled:bamboo_planks_small_tiles",
  "rechiseled:bamboo_planks_small_tiles_connecting",
  "rechiseled:bamboo_planks_squares",
  "rechiseled:bamboo_planks_squares_connecting",
  "rechiseled:bamboo_planks_tiles",
  "rechiseled:bamboo_planks_tiles_connecting",
  "rechiseled:bamboo_planks_wavy",
  "rechiseled:bamboo_planks_wavy_connecting",
  "rechiseled:bamboo_planks_woven",
  "rechiseled:bamboo_planks_woven_connecting",
];
const rechiseled_birch = [
  "rechiseled:birch_planks_beams",
  "rechiseled:birch_planks_beams_connecting",
  "rechiseled:birch_planks_brick_pattern",
  "rechiseled:birch_planks_brick_pattern_connecting",
  "rechiseled:birch_planks_brick_paving",
  "rechiseled:birch_planks_brick_paving_connecting",
  "rechiseled:birch_planks_bricks",
  "rechiseled:birch_planks_bricks_connecting",
  "rechiseled:birch_planks_crate",
  "rechiseled:birch_planks_crate_connecting",
  "rechiseled:birch_planks_diagonal_stripes",
  "rechiseled:birch_planks_diagonal_stripes_connecting",
  "rechiseled:birch_planks_diagonal_tiles",
  "rechiseled:birch_planks_diagonal_tiles_connecting",
  "rechiseled:birch_planks_dotted",
  "rechiseled:birch_planks_dotted_connecting",
  "rechiseled:birch_planks_flooring",
  "rechiseled:birch_planks_flooring_connecting",
  "rechiseled:birch_planks_large_tiles",
  "rechiseled:birch_planks_large_tiles_connecting",
  "rechiseled:birch_planks_mosaic",
  "rechiseled:birch_planks_pattern",
  "rechiseled:birch_planks_pattern_connecting",
  "rechiseled:birch_planks_rotated_bricks",
  "rechiseled:birch_planks_rotated_bricks_connecting",
  "rechiseled:birch_planks_small_bricks",
  "rechiseled:birch_planks_small_bricks_connecting",
  "rechiseled:birch_planks_small_tiles",
  "rechiseled:birch_planks_small_tiles_connecting",
  "rechiseled:birch_planks_squares",
  "rechiseled:birch_planks_squares_connecting",
  "rechiseled:birch_planks_tiles",
  "rechiseled:birch_planks_tiles_connecting",
  "rechiseled:birch_planks_wavy",
  "rechiseled:birch_planks_wavy_connecting",
  "rechiseled:birch_planks_woven",
  "rechiseled:birch_planks_woven_connecting",
];
const rechiseled_cherry = [
  "rechiseled:cherry_planks_beams",
  "rechiseled:cherry_planks_beams_connecting",
  "rechiseled:cherry_planks_brick_pattern",
  "rechiseled:cherry_planks_brick_pattern_connecting",
  "rechiseled:cherry_planks_brick_paving",
  "rechiseled:cherry_planks_brick_paving_connecting",
  "rechiseled:cherry_planks_bricks",
  "rechiseled:cherry_planks_bricks_connecting",
  "rechiseled:cherry_planks_crate",
  "rechiseled:cherry_planks_crate_connecting",
  "rechiseled:cherry_planks_diagonal_stripes",
  "rechiseled:cherry_planks_diagonal_stripes_connecting",
  "rechiseled:cherry_planks_diagonal_tiles",
  "rechiseled:cherry_planks_diagonal_tiles_connecting",
  "rechiseled:cherry_planks_dotted",
  "rechiseled:cherry_planks_dotted_connecting",
  "rechiseled:cherry_planks_flooring",
  "rechiseled:cherry_planks_flooring_connecting",
  "rechiseled:cherry_planks_large_tiles",
  "rechiseled:cherry_planks_large_tiles_connecting",
  "rechiseled:cherry_planks_mosaic",
  "rechiseled:cherry_planks_pattern",
  "rechiseled:cherry_planks_pattern_connecting",
  "rechiseled:cherry_planks_rotated_bricks",
  "rechiseled:cherry_planks_rotated_bricks_connecting",
  "rechiseled:cherry_planks_small_bricks",
  "rechiseled:cherry_planks_small_bricks_connecting",
  "rechiseled:cherry_planks_small_tiles",
  "rechiseled:cherry_planks_small_tiles_connecting",
  "rechiseled:cherry_planks_squares",
  "rechiseled:cherry_planks_squares_connecting",
  "rechiseled:cherry_planks_tiles",
  "rechiseled:cherry_planks_tiles_connecting",
  "rechiseled:cherry_planks_wavy",
  "rechiseled:cherry_planks_wavy_connecting",
  "rechiseled:cherry_planks_woven",
  "rechiseled:cherry_planks_woven_connecting",
];
const rechiseled_crimson = [
  "rechiseled:crimson_planks_beams",
  "rechiseled:crimson_planks_beams_connecting",
  "rechiseled:crimson_planks_brick_pattern",
  "rechiseled:crimson_planks_brick_pattern_connecting",
  "rechiseled:crimson_planks_brick_paving",
  "rechiseled:crimson_planks_brick_paving_connecting",
  "rechiseled:crimson_planks_bricks",
  "rechiseled:crimson_planks_bricks_connecting",
  "rechiseled:crimson_planks_crate",
  "rechiseled:crimson_planks_crate_connecting",
  "rechiseled:crimson_planks_diagonal_stripes",
  "rechiseled:crimson_planks_diagonal_stripes_connecting",
  "rechiseled:crimson_planks_diagonal_tiles",
  "rechiseled:crimson_planks_diagonal_tiles_connecting",
  "rechiseled:crimson_planks_dotted",
  "rechiseled:crimson_planks_dotted_connecting",
  "rechiseled:crimson_planks_flooring",
  "rechiseled:crimson_planks_flooring_connecting",
  "rechiseled:crimson_planks_large_tiles",
  "rechiseled:crimson_planks_large_tiles_connecting",
  "rechiseled:crimson_planks_mosaic",
  "rechiseled:crimson_planks_pattern",
  "rechiseled:crimson_planks_pattern_connecting",
  "rechiseled:crimson_planks_rotated_bricks",
  "rechiseled:crimson_planks_rotated_bricks_connecting",
  "rechiseled:crimson_planks_small_bricks",
  "rechiseled:crimson_planks_small_bricks_connecting",
  "rechiseled:crimson_planks_small_tiles",
  "rechiseled:crimson_planks_small_tiles_connecting",
  "rechiseled:crimson_planks_squares",
  "rechiseled:crimson_planks_squares_connecting",
  "rechiseled:crimson_planks_tiles",
  "rechiseled:crimson_planks_tiles_connecting",
  "rechiseled:crimson_planks_wavy",
  "rechiseled:crimson_planks_wavy_connecting",
  "rechiseled:crimson_planks_woven",
  "rechiseled:crimson_planks_woven_connecting",
];
const rechiseled_dark_oak = [
  "rechiseled:dark_oak_planks_beams",
  "rechiseled:dark_oak_planks_beams_connecting",
  "rechiseled:dark_oak_planks_brick_pattern",
  "rechiseled:dark_oak_planks_brick_pattern_connecting",
  "rechiseled:dark_oak_planks_brick_paving",
  "rechiseled:dark_oak_planks_brick_paving_connecting",
  "rechiseled:dark_oak_planks_bricks",
  "rechiseled:dark_oak_planks_bricks_connecting",
  "rechiseled:dark_oak_planks_crate",
  "rechiseled:dark_oak_planks_crate_connecting",
  "rechiseled:dark_oak_planks_diagonal_stripes",
  "rechiseled:dark_oak_planks_diagonal_stripes_connecting",
  "rechiseled:dark_oak_planks_diagonal_tiles",
  "rechiseled:dark_oak_planks_diagonal_tiles_connecting",
  "rechiseled:dark_oak_planks_dotted",
  "rechiseled:dark_oak_planks_dotted_connecting",
  "rechiseled:dark_oak_planks_flooring",
  "rechiseled:dark_oak_planks_flooring_connecting",
  "rechiseled:dark_oak_planks_large_tiles",
  "rechiseled:dark_oak_planks_large_tiles_connecting",
  "rechiseled:dark_oak_planks_mosaic",
  "rechiseled:dark_oak_planks_pattern",
  "rechiseled:dark_oak_planks_pattern_connecting",
  "rechiseled:dark_oak_planks_rotated_bricks",
  "rechiseled:dark_oak_planks_rotated_bricks_connecting",
  "rechiseled:dark_oak_planks_small_bricks",
  "rechiseled:dark_oak_planks_small_bricks_connecting",
  "rechiseled:dark_oak_planks_small_tiles",
  "rechiseled:dark_oak_planks_small_tiles_connecting",
  "rechiseled:dark_oak_planks_squares",
  "rechiseled:dark_oak_planks_squares_connecting",
  "rechiseled:dark_oak_planks_tiles",
  "rechiseled:dark_oak_planks_tiles_connecting",
  "rechiseled:dark_oak_planks_wavy",
  "rechiseled:dark_oak_planks_wavy_connecting",
  "rechiseled:dark_oak_planks_woven",
  "rechiseled:dark_oak_planks_woven_connecting",
];
const rechiseled_jungle = [
  "rechiseled:jungle_planks_beams",
  "rechiseled:jungle_planks_beams_connecting",
  "rechiseled:jungle_planks_brick_pattern",
  "rechiseled:jungle_planks_brick_pattern_connecting",
  "rechiseled:jungle_planks_brick_paving",
  "rechiseled:jungle_planks_brick_paving_connecting",
  "rechiseled:jungle_planks_bricks",
  "rechiseled:jungle_planks_bricks_connecting",
  "rechiseled:jungle_planks_crate",
  "rechiseled:jungle_planks_crate_connecting",
  "rechiseled:jungle_planks_diagonal_stripes",
  "rechiseled:jungle_planks_diagonal_stripes_connecting",
  "rechiseled:jungle_planks_diagonal_tiles",
  "rechiseled:jungle_planks_diagonal_tiles_connecting",
  "rechiseled:jungle_planks_dotted",
  "rechiseled:jungle_planks_dotted_connecting",
  "rechiseled:jungle_planks_flooring",
  "rechiseled:jungle_planks_flooring_connecting",
  "rechiseled:jungle_planks_large_tiles",
  "rechiseled:jungle_planks_large_tiles_connecting",
  "rechiseled:jungle_planks_mosaic",
  "rechiseled:jungle_planks_pattern",
  "rechiseled:jungle_planks_pattern_connecting",
  "rechiseled:jungle_planks_rotated_bricks",
  "rechiseled:jungle_planks_rotated_bricks_connecting",
  "rechiseled:jungle_planks_small_bricks",
  "rechiseled:jungle_planks_small_bricks_connecting",
  "rechiseled:jungle_planks_small_tiles",
  "rechiseled:jungle_planks_small_tiles_connecting",
  "rechiseled:jungle_planks_squares",
  "rechiseled:jungle_planks_squares_connecting",
  "rechiseled:jungle_planks_tiles",
  "rechiseled:jungle_planks_tiles_connecting",
  "rechiseled:jungle_planks_wavy",
  "rechiseled:jungle_planks_wavy_connecting",
  "rechiseled:jungle_planks_woven",
  "rechiseled:jungle_planks_woven_connecting",
];
const rechiseled_mangrove = [
  "rechiseled:mangrove_planks_beams",
  "rechiseled:mangrove_planks_beams_connecting",
  "rechiseled:mangrove_planks_brick_pattern",
  "rechiseled:mangrove_planks_brick_pattern_connecting",
  "rechiseled:mangrove_planks_brick_paving",
  "rechiseled:mangrove_planks_brick_paving_connecting",
  "rechiseled:mangrove_planks_bricks",
  "rechiseled:mangrove_planks_bricks_connecting",
  "rechiseled:mangrove_planks_crate",
  "rechiseled:mangrove_planks_crate_connecting",
  "rechiseled:mangrove_planks_diagonal_stripes",
  "rechiseled:mangrove_planks_diagonal_stripes_connecting",
  "rechiseled:mangrove_planks_diagonal_tiles",
  "rechiseled:mangrove_planks_diagonal_tiles_connecting",
  "rechiseled:mangrove_planks_dotted",
  "rechiseled:mangrove_planks_dotted_connecting",
  "rechiseled:mangrove_planks_flooring",
  "rechiseled:mangrove_planks_flooring_connecting",
  "rechiseled:mangrove_planks_large_tiles",
  "rechiseled:mangrove_planks_large_tiles_connecting",
  "rechiseled:mangrove_planks_mosaic",
  "rechiseled:mangrove_planks_pattern",
  "rechiseled:mangrove_planks_pattern_connecting",
  "rechiseled:mangrove_planks_rotated_bricks",
  "rechiseled:mangrove_planks_rotated_bricks_connecting",
  "rechiseled:mangrove_planks_small_bricks",
  "rechiseled:mangrove_planks_small_bricks_connecting",
  "rechiseled:mangrove_planks_small_tiles",
  "rechiseled:mangrove_planks_small_tiles_connecting",
  "rechiseled:mangrove_planks_squares",
  "rechiseled:mangrove_planks_squares_connecting",
  "rechiseled:mangrove_planks_tiles",
  "rechiseled:mangrove_planks_tiles_connecting",
  "rechiseled:mangrove_planks_wavy",
  "rechiseled:mangrove_planks_wavy_connecting",
  "rechiseled:mangrove_planks_woven",
  "rechiseled:mangrove_planks_woven_connecting",
];
const rechiseled_oak = [
  "rechiseled:oak_planks_beams",
  "rechiseled:oak_planks_beams_connecting",
  "rechiseled:oak_planks_brick_pattern",
  "rechiseled:oak_planks_brick_pattern_connecting",
  "rechiseled:oak_planks_brick_paving",
  "rechiseled:oak_planks_brick_paving_connecting",
  "rechiseled:oak_planks_bricks",
  "rechiseled:oak_planks_bricks_connecting",
  "rechiseled:oak_planks_crate",
  "rechiseled:oak_planks_crate_connecting",
  "rechiseled:oak_planks_diagonal_stripes",
  "rechiseled:oak_planks_diagonal_stripes_connecting",
  "rechiseled:oak_planks_diagonal_tiles",
  "rechiseled:oak_planks_diagonal_tiles_connecting",
  "rechiseled:oak_planks_dotted",
  "rechiseled:oak_planks_dotted_connecting",
  "rechiseled:oak_planks_flooring",
  "rechiseled:oak_planks_flooring_connecting",
  "rechiseled:oak_planks_large_tiles",
  "rechiseled:oak_planks_large_tiles_connecting",
  "rechiseled:oak_planks_mosaic",
  "rechiseled:oak_planks_pattern",
  "rechiseled:oak_planks_pattern_connecting",
  "rechiseled:oak_planks_rotated_bricks",
  "rechiseled:oak_planks_rotated_bricks_connecting",
  "rechiseled:oak_planks_small_bricks",
  "rechiseled:oak_planks_small_bricks_connecting",
  "rechiseled:oak_planks_small_tiles",
  "rechiseled:oak_planks_small_tiles_connecting",
  "rechiseled:oak_planks_squares",
  "rechiseled:oak_planks_squares_connecting",
  "rechiseled:oak_planks_tiles",
  "rechiseled:oak_planks_tiles_connecting",
  "rechiseled:oak_planks_wavy",
  "rechiseled:oak_planks_wavy_connecting",
  "rechiseled:oak_planks_woven",
  "rechiseled:oak_planks_woven_connecting",
];
const rechiseled_spruce = [
  "rechiseled:spruce_planks_beams",
  "rechiseled:spruce_planks_beams_connecting",
  "rechiseled:spruce_planks_brick_pattern",
  "rechiseled:spruce_planks_brick_pattern_connecting",
  "rechiseled:spruce_planks_brick_paving",
  "rechiseled:spruce_planks_brick_paving_connecting",
  "rechiseled:spruce_planks_bricks",
  "rechiseled:spruce_planks_bricks_connecting",
  "rechiseled:spruce_planks_crate",
  "rechiseled:spruce_planks_crate_connecting",
  "rechiseled:spruce_planks_diagonal_stripes",
  "rechiseled:spruce_planks_diagonal_stripes_connecting",
  "rechiseled:spruce_planks_diagonal_tiles",
  "rechiseled:spruce_planks_diagonal_tiles_connecting",
  "rechiseled:spruce_planks_dotted",
  "rechiseled:spruce_planks_dotted_connecting",
  "rechiseled:spruce_planks_flooring",
  "rechiseled:spruce_planks_flooring_connecting",
  "rechiseled:spruce_planks_large_tiles",
  "rechiseled:spruce_planks_large_tiles_connecting",
  "rechiseled:spruce_planks_mosaic",
  "rechiseled:spruce_planks_pattern",
  "rechiseled:spruce_planks_pattern_connecting",
  "rechiseled:spruce_planks_rotated_bricks",
  "rechiseled:spruce_planks_rotated_bricks_connecting",
  "rechiseled:spruce_planks_small_bricks",
  "rechiseled:spruce_planks_small_bricks_connecting",
  "rechiseled:spruce_planks_small_tiles",
  "rechiseled:spruce_planks_small_tiles_connecting",
  "rechiseled:spruce_planks_squares",
  "rechiseled:spruce_planks_squares_connecting",
  "rechiseled:spruce_planks_tiles",
  "rechiseled:spruce_planks_tiles_connecting",
  "rechiseled:spruce_planks_wavy",
  "rechiseled:spruce_planks_wavy_connecting",
  "rechiseled:spruce_planks_woven",
  "rechiseled:spruce_planks_woven_connecting",
];
const rechiseled_warped = [
  "rechiseled:warped_planks_beams",
  "rechiseled:warped_planks_beams_connecting",
  "rechiseled:warped_planks_brick_pattern",
  "rechiseled:warped_planks_brick_pattern_connecting",
  "rechiseled:warped_planks_brick_paving",
  "rechiseled:warped_planks_brick_paving_connecting",
  "rechiseled:warped_planks_bricks",
  "rechiseled:warped_planks_bricks_connecting",
  "rechiseled:warped_planks_crate",
  "rechiseled:warped_planks_crate_connecting",
  "rechiseled:warped_planks_diagonal_stripes",
  "rechiseled:warped_planks_diagonal_stripes_connecting",
  "rechiseled:warped_planks_diagonal_tiles",
  "rechiseled:warped_planks_diagonal_tiles_connecting",
  "rechiseled:warped_planks_dotted",
  "rechiseled:warped_planks_dotted_connecting",
  "rechiseled:warped_planks_flooring",
  "rechiseled:warped_planks_flooring_connecting",
  "rechiseled:warped_planks_large_tiles",
  "rechiseled:warped_planks_large_tiles_connecting",
  "rechiseled:warped_planks_mosaic",
  "rechiseled:warped_planks_pattern",
  "rechiseled:warped_planks_pattern_connecting",
  "rechiseled:warped_planks_rotated_bricks",
  "rechiseled:warped_planks_rotated_bricks_connecting",
  "rechiseled:warped_planks_small_bricks",
  "rechiseled:warped_planks_small_bricks_connecting",
  "rechiseled:warped_planks_small_tiles",
  "rechiseled:warped_planks_small_tiles_connecting",
  "rechiseled:warped_planks_squares",
  "rechiseled:warped_planks_squares_connecting",
  "rechiseled:warped_planks_tiles",
  "rechiseled:warped_planks_tiles_connecting",
  "rechiseled:warped_planks_wavy",
  "rechiseled:warped_planks_wavy_connecting",
  "rechiseled:warped_planks_woven",
  "rechiseled:warped_planks_woven_connecting",
];

const bwg_crafting_tables = [
  "biomeswevegone:aspen_crafting_table",
  "biomeswevegone:baobab_crafting_table",
  "biomeswevegone:blue_enchanted_crafting_table",
  "biomeswevegone:cika_crafting_table",
  "biomeswevegone:cypress_crafting_table",
  "biomeswevegone:ebony_crafting_table",
  "biomeswevegone:fir_crafting_table",
  "biomeswevegone:florus_crafting_table",
  "biomeswevegone:green_enchanted_crafting_table",
  "biomeswevegone:holly_crafting_table",
  "biomeswevegone:ironwood_crafting_table",
  "biomeswevegone:jacaranda_crafting_table",
  "biomeswevegone:mahogany_crafting_table",
  "biomeswevegone:maple_crafting_table",
  "biomeswevegone:palm_crafting_table",
  "biomeswevegone:pine_crafting_table",
  "biomeswevegone:rainbow_eucalyptus_crafting_table",
  "biomeswevegone:redwood_crafting_table",
  "biomeswevegone:sakura_crafting_table",
  "biomeswevegone:skyris_crafting_table",
  "biomeswevegone:white_mangrove_crafting_table",
  "biomeswevegone:willow_crafting_table",
  "biomeswevegone:witch_hazel_crafting_table",
  "biomeswevegone:zelkova_crafting_table",
];

const xyAluminum = [
  "xycraft_world:aluminum_ore_stone",
  "xycraft_world:aluminum_ore_kivi",
  "xycraft_world:aluminum_ore_deepslate",
];

const ender_pearl_variations = [
  "endermanoverhaul:corrupted_pearl",
  "endermanoverhaul:soul_pearl",
  "endermanoverhaul:ancient_pearl",
  "endermanoverhaul:bubble_pearl",
  "endermanoverhaul:summoner_pearl",
  "endermanoverhaul:icy_pearl",
  "endermanoverhaul:crimson_pearl",
  "endermanoverhaul:warped_pearl",
];


const factoryBlocks = [
  "factory_blocks:factory",
  "factory_blocks:rust",
  "factory_blocks:vrust",
  "factory_blocks:srust",
  "factory_blocks:wireframe",
  "factory_blocks:pwireframe",
  "factory_blocks:hazard",
  "factory_blocks:hazardo",
  "factory_blocks:circuit",
  "factory_blocks:metalbox",
  "factory_blocks:pgcircuit",
  "factory_blocks:gcircuit",
  "factory_blocks:grinder",
  "factory_blocks:old_vents",
  "factory_blocks:rust_plates",
  "factory_blocks:bcircuit",
  "factory_blocks:ice",
  "factory_blocks:bwireframe",
  "factory_blocks:mosaic",
  "factory_blocks:rusty_scaffold",
  "factory_blocks:caution",
  "factory_blocks:small_pipes",
  "factory_blocks:large_pipes",
  "factory_blocks:vent",
  "factory_blocks:gvent",
  "factory_blocks:insulation",
  "factory_blocks:megacell",
  "factory_blocks:fan_malfunction_on",
  "factory_blocks:fan_four_on",
  "factory_blocks:fan_on",
  "factory_blocks:fan_side",
  "factory_blocks:large_plating",
  "factory_blocks:exhaust",
  "factory_blocks:piping",
  "factory_blocks:scaffold",
  "factory_blocks:engineer",
  "factory_blocks:medium_fan",
  "factory_blocks:fan_malfunction",
  "factory_blocks:fan_four",
  "factory_blocks:fan"
]

const yeeted_fluids = [
  "pneumaticcraft:biodiesel",
  "immersiveengineering:biodiesel",
  "pneumaticcraft:ethanol",
  "immersiveengineering:ethanol",
  "immersiveengineering:plantoil",
  "pneumaticcraft:vegetable_oil",
  "modern_industrialization:creosote",
  "oritech:still_steam",
  "oritech:flowing_steam",
  "oritech:still_diesel",
  "oritech:flowing_diesel",
  "oritech:still_oil",
  "oritech:flowing_oil",
  "oritech:still_sulfuric_acid",
  "oritech:flowing_sulfuric_acid",
  "oritech:still_naphtha",
  "oritech:flowing_naphtha",
  "pneumaticcraft:diesel",
  "mekanism:sulfuric_acid",
  "mekanism:steam",
  "mekanism:oxygen",
  "mekanism:chlorine",
  "mekanism:hydrogen"
];

const relocation_not_supported = [
  "oritech:item_filter_block",
  "oritech:pulverizer_block",
  "oritech:fragment_forge_block",
  "oritech:assembler_block",
  "oritech:foundry_block",
  "oritech:cooler_block",
  "oritech:centrifuge_block",
  "oritech:atomic_forge_block",
  "oritech:refinery_block",
  "oritech:refinery_module_block",
  "oritech:bio_generator_block",
  "oritech:lava_generator_block",
  "oritech:fuel_generator_block",
  "oritech:basic_generator_block",
  "oritech:steam_engine_block",
  "oritech:big_solar_panel_block",
  "oritech:powered_furnace_block",
  "oritech:laser_arm_block",
  "oritech:deep_drill_block",
  "oritech:drone_port_block",
  "oritech:shrinker_block",
  "oritech:small_storage_block",
  "oritech:large_storage_block",
  "oritech:creative_storage_block",
  "oritech:small_tank_block",
  "oritech:creative_tank_block",
  "oritech:augment_application_block",
  "oritech:simple_augment_station",
  "oritech:advanced_augment_station",
  "oritech:arcane_augment_station",
  "oritech:placer_block",
  "oritech:destroyer_block",
  "oritech:fertilizer_block",
  "oritech:treefeller_block",
  "oritech:pipe_booster_block",
  "oritech:enchantment_catalyst_block",
  "oritech:enchanter_block",
  "oritech:spawner_controller_block",
  "oritech:wither_crop_block",
  "oritech:accelerator_ring",
  "oritech:accelerator_motor",
  "oritech:accelerator_controller",
  "oritech:accelerator_sensor",
  "oritech:black_hole_block",
  "oritech:particle_collector_block",
  "oritech:pump_block",
  "oritech:charger_block",
  "oritech:machine_speed_addon",
  "oritech:machine_efficiency_addon",
  "oritech:machine_ultimate_addon",
  "oritech:quarry_addon",
  "oritech:machine_processing_addon",
  "oritech:machine_fluid_addon",
  "oritech:machine_yield_addon",
  "oritech:crop_filter_addon",
  "oritech:machine_hunter_addon",
  "oritech:machine_capacitor_addon",
  "oritech:machine_acceptor_addon",
  "oritech:machine_inventory_proxy_addon",
  "oritech:steam_boiler_addon",
  "oritech:machine_redstone_addon",
  "oritech:machine_silk_touch_addon",
  "oritech:machine_burst_addon",
  "oritech:reactor_controller"
];

ServerEvents.tags("item", (event) => {
  //tag additions

  arcaneOres.forEach((ore) => {
    event.add("c:ores/arcane", ore);
  });

  //Adding Create's Andesite Blocks to the Chipped Andesite Tag.
  event.add("chipped:andesite", ["create:cut_andesite", "create:polished_cut_andesite", "create:cut_andesite_bricks", "create:small_andesite_bricks", "create:layered_andesite", "create:andesite_pillar"])
  //Adding Create's Granite Blocks to the Chipped Granite Tag.
  event.add("chipped:granite", ["create:cut_granite", "create:polished_cut_granite", "create:cut_granite_bricks", "create:small_granite_bricks", "create:layered_granite", "create:granite_pillar"])
  //Adding Create's Diorite Blocks to the Chipped Diorite Tag.
  event.add("chipped:diorite", ["create:cut_diorite", "create:polished_cut_diorite", "create:cut_diorite_bricks", "create:small_diorite_bricks", "create:layered_diorite", "create:diorite_pillar"])
  //Adding Create's Calcite Blocks to the Chipped Calcite Tag.
  event.add("chipped:calcite", ["create:cut_calcite", "create:polished_cut_calcite", "create:cut_calcite_bricks", "create:small_calcite_bricks", "create:layered_calcite", "create:calcite_pillar"])
  //Adding Create's Dripstone Blocks to the Chipped Dripstone Tag.
  event.add("chipped:dripstone_block", ["create:cut_dripstone", "create:polished_cut_dripstone", "create:cut_dripstone_bricks", "create:small_dripstone_bricks", "create:layered_dripstone", "create:dripstone_pillar"])
  //Adding Create's Deepslate Blocks to the Chipped Deepslate Tag.
  event.add("chipped:deepslate", ["create:cut_deepslate", "create:polished_cut_deepslate", "create:cut_deepslate_bricks", "create:small_deepslate_bricks", "create:layered_deepslate", "create:deepslate_pillar"])
  //Adding Create's Tuff Blocks to the Chipped Tuff Tag.
  event.add("chipped:tuff", ["create:cut_tuff", "create:polished_cut_tuff", "create:cut_tuff_bricks", "create:small_tuff_bricks", "create:layered_tuff", "create:tuff_pillar"])
  //Adding Create's Waxed Copper Blocks to the Chipped Waxed Copper Tag.
  event.add("chipped:waxed_copper_block", ["create:waxed_copper_shingles", "create:waxed_copper_tiles"])
  event.add("chipped:waxed_exposed_copper_block", ["create:waxed_exposed_copper_shingles", "create:waxed_exposed_copper_tiles"])
  event.add("chipped:waxed_weathered_copper", ["create:waxed_weathered_copper_shingles", "create:waxed_weathered_copper_tiles"])
  event.add("chipped:waxed_oxidized_copper", ["create:waxed_oxidized_copper_shingles", "create:waxed_oxidized_copper_tiles"])


  //Adding PNC Flour to the Create Flour Tag
  event.add("c:flours/wheat", "pneumaticcraft:wheat_flour")

  factoryBlocks.forEach((factoryBlock) => {
    event.add("minecraft:mineable/pickaxe", factoryBlock);
  });

  xyAluminum.forEach((aluminum) => {
    event.add("c:ores/xy_aluminum", aluminum);
    event.remove("c:ores/aluminum", aluminum);
  });

  //Giving the Recently Added Xycraft items the correct tags.
  const xycraft_meka_item_types = [
    "shards",
    "crystals",
    "clumps",
    "dirty_dusts"
  ];

  xycraft_meka_item_types.forEach(type => {
    event.remove(`c:${type}/aluminum`, `xycraft_machines:aluminum_${type.slice(0, -1)}`);
    event.add(`c:${type}/xy_aluminum`, `xycraft_machines:aluminum_${type.slice(0, -1)}`);
  });

  event.add("ftb:enderman_head", "enderio:enderman_head", "heads:enderman_head");

  event.add("minecraft:short_grass", ['projectvibrantjourneys:short_grass','minecraft:short_grass']);
  event.add("c:wires/tin", "modern_industrialization:tin_wire");
  event.add("c:wires", "modern_industrialization:tin_wire");
  event.add("c:coal_coke", "modern_industrialization:coke");
  event.add("c:rods/xy_aluminum", "immersiveengineering:stick_aluminum");
  event.add("c:rods", "immersiveengineering:stick_aluminum");
  event.add("c:plates/xy_aluminum", "immersiveengineering:plate_aluminum");
  event.add("c:plates", "immersiveengineering:plate_aluminum");
  event.remove("c:plates/aluminium", "immersiveengineering:plate_aluminum");
  event.remove("c:rods/aluminium", "immersiveengineering:stick_aluminum");
  event.remove("c:plates/aluminum", "immersiveengineering:plate_aluminum");
  event.remove("c:rods/aluminum", "immersiveengineering:stick_aluminum");
  event.add("c:dusts/xy_aluminum", "ftbevolution:xy_aluminum_dust");
  event.add("c:dusts", "ftbevolution:xy_aluminum_dust");
  event.add("c:dusts/coal_coke", "modern_industrialization:coke_dust");
  event.add(
    "c:storage_blocks/coal_coke",
    "modern_industrialization:coke_block"
  );
  event.add("c:ingots/xy_aluminum", "xycraft_world:aluminum_ingot");
  event.add("c:nuggets/xy_aluminum", "xycraft_world:aluminum_nugget");
  event.remove("c:raw_materials/aluminum", "xycraft_world:raw_aluminum_block");
  event.remove("c:rods/aluminum", "immersiveengineering:stick_aluminum");
  event.remove(
    "c:storage_blocks/raw_aluminum",
    "xycraft_world:raw_aluminum_block"
  );
  event.remove("c:ingots/aluminum", "xycraft_world:aluminum_ingot");
  event.remove("c:nuggets/aluminum", "xycraft_world:aluminum_nugget");

  miHammers.forEach((hammer) => {
    event.add("modern_industrialization:forge_hammer_tools", hammer);
  });

  stellaBlacklist.forEach((id) => {
    event.add("forbidden_arcanus:items/indestructible_blacklisted", id);
    event.add("forbidden_arcanus:modifier/eternal_incompatible", id);
  });
  event.add("c:glass/colorless", [
    "#c:glass_blocks/colorless",
    "minecraft:glass",
  ]);
  yieldBlacklist.forEach((id) => {
    event.add("enchantableblocks:yield_blacklist", id);
  });

  //Adding Cadmium Tiny Dusts to Cadmium Nuggets tag so the IE Arc recycling recipe for Cadmium Rods actually makes something.
  event.add("c:nuggets/cadmium", "modern_industrialization:cadmium_tiny_dust");

  //rods
  event.add("c:rods", ["ftbmaterials:bronze_rod"]);
  event.add("c:rods/bronze", ["ftbmaterials:bronze_rod"]);
  event.remove("c:hidden_from_recipe_viewers", ["ftbmaterials:bronze_rod"]);

  event.add("c:rods", ["ftbmaterials:invar_rod"]);
  event.add("c:rods/invar", ["ftbmaterials:invar_rod"]);
  event.remove("c:hidden_from_recipe_viewers", ["ftbmaterials:invar_rod"]);

  event.add("c:rods", ["ftbmaterials:tin_rod"]);
  event.add("c:rods/tin", ["ftbmaterials:tin_rod"]);
  event.remove("c:hidden_from_recipe_viewers", ["ftbmaterials:tin_rod"]);

  event.add("c:rods", ["ftbmaterials:steel_rod"]);
  event.add("c:rods/steel", ["ftbmaterials:steel_rod"]);
  event.remove("c:hidden_from_recipe_viewers", ["ftbmaterials:steel_rod"]);

  event.add("c:rods", ["ftbmaterials:iron_rod"]);
  event.add("c:rods/iron", ["ftbmaterials:iron_rod"]);
  event.remove("c:hidden_from_recipe_viewers", ["ftbmaterials:iron_rod"]);

  event.remove("c:water", ["oritech:still_oil_bucket"]);

  //Fixes a lot of issues caused by mods taking this tag as an input and getting hidden.
	event.remove("c:ingots", "malum:malignant_pewter_ingot")

  event.add("c:rods", ["ftbmaterials:netherite_rod"]);
  event.add("c:rods/netherite", ["ftbmaterials:netherite_rod"]);
  event.remove("c:hidden_from_recipe_viewers", ["ftbmaterials:netherite_rod"]);
  
  //Adding Silent Gear's Silks to the String Tag
  event.add("c:strings", ["silentgear:fine_silk"]);
  event.add("c:strings", ["silentgear:fluffy_string"]);

  //Adding OhTheBiomes Pumpkin to a more general Pumpkin Tag
  event.add("chipped:pumpkin", ["biomeswevegone:pale_pumpkin"]);

  event.add("c:plates", ["ftbmaterials:gold_plate"]);
  event.add("c:plates/gold", ["ftbmaterials:gold_plate"]);
  event.remove("c:hidden_from_recipe_viewers", ["ftbmaterials:gold_plate"]);

  event.remove("c:hidden_from_recipe_viewers", [
    "modern_industrialization:diamond_plate",
  ]);
  event.add("c:plates", ["modern_industrialization:diamond_plate"]);
  event.add("c:plates/diamond", ["modern_industrialization:diamond_plate"]);
  event.add("c:plates", ["modern_industrialization:emerald_plate"]);
  event.add("c:plates/emerald", ["modern_industrialization:emerald_plate"]);
  event.add("c:sawdust", "mekanism:sawdust");
  event.add("c:rubbers", "modern_industrialization:rubber_sheet");
  event.add("c:rubber", "modern_industrialization:rubber_sheet");
  event.add("enchantableblocks:yield_blacklist", "#c:ingots");
  event.add("enchantableblocks:yield_blacklist", "#c:nuggets");
  event.add("enchantableblocks:yield_blacklist", "#c:gems");
  event.add("enchantableblocks:yield_blacklist", "#c:storage_blocks");
  event.add("megacells:compression_overrides", "productivebees:obsidian_shard");
  event.add(
    "functionalstorage:ignore_crafting_check",
    "the_bumblezone:pollen_puff"
  );

  //Dealing with Fluid Buckets
  yeeted_fluids.forEach(fluid => {
    let mod_id = fluid.split(":")[0];
    let fluid_id = fluid.split(":")[1];

    if (!fluid_id.includes("flowing")) {
      event.add("c:hidden_from_recipe_viewers", `${mod_id}:${fluid_id}_bucket`);
    } else { return }
  });

  //Fixing Blackthorn Sticks Recipe.
  const blackthorn_planks_blacklist = ["productivetrees:blackthorn_planks", "paganbless:black_thorn_planks"];  
  event.get("minecraft:planks").getObjectIds().forEach(plank => {
    if (!blackthorn_planks_blacklist.includes(plank.toString())) {
      event.add("ftb:non_blackthorn_planks", plank.toString());
    }
  });
  const blackthorn_logs_blacklist = ["productivetrees:blackthorn_log", "productivetrees:blackthorn_stripped_log", "productivetrees:blackthorn_wood", "productivetrees:blackthorn_stripped_wood", "paganbless:black_thorn_log", "paganbless:stripped_black_thorn_log", "paganbless:black_thorn_wood", "paganbless:stripped_black_thorn_wood"];  
  event.get("minecraft:logs").getObjectIds().forEach(log => {
    if (!blackthorn_logs_blacklist.includes(log.toString())) {
      event.add("ftb:non_blackthorn_logs", log.toString());
    }
  });

  event.add("forge:ingots/iron", ["minecraft:iron_ingot"]);
  event.add("c:hidden_from_recipe_viewers", jeiBlacklist);
  event.add("c:ores/uranium", ["bigreactors:deepslate_yellorite_ore"]);
  event.add("forge:ingots/iron", ["minecraft:iron_ingot"]);
  event.add("forge:dusts/redstone", ["minecraft:redstone"]);
  event.add("functionalstorage:ignore_crafting_check", "minecraft:snowball");
  event.add("functionalstorage:ignore_crafting_check", "minecraft:string");
  event.add("megacells:compression_overrides", "minecraft:string");
  event.add("forge:glass_panes/colorless", ["minecraft:glass_pane"]);
  event.add("c:plastics", "pneumaticcraft:plastic");
  event.add("c:dusts", ["mysticalagriculture:soulium_dust"]);
  event.add("c:dusts/soulium", ["mysticalagriculture:soulium_dust"]);
  event.add(
    "functionalstorage:ignore_crafting_check",
    "productivebees:draconic_dust"
  );
  event.add(
    "functionalstorage:ignore_crafting_check",
    "productivebees:obsidian_shard"
  );
  event.add("productivebees:flowers/plastic", "industrialforegoing:plastic");

  //Adding Industrial Foregoing to other Plastics Tags
  event.add("pneumaticcraft:plastic_sheets", "industrialforegoing:plastic");
  event.add("c:plates/plastic", "industrialforegoing:plastic");

	//Making Duroplast its own Thing, separate from Plastic Sheets.
	event.remove("c:plates/plastic", "immersiveengineering:plate_duroplast");
	event.add("c:plates/duroplast", "immersiveengineering:plate_duroplast");

  //No Longer needed since Boon of Earth Drops are handled through the Loot Tables in
  //kubejs\data\apothic_enchanting\loot_table
  // removeBoonDrops.forEach(boonItem => {
  //   event.remove("c:ores_in_ground/stone", boonItem);
  //   event.remove("c:ores_in_ground/netherrack", boonItem);
  //   event.remove("c:ores_in_ground/end", boonItem);
  // });

  //remove globally ununified items
  global["unUnified"].forEach((id) => {
    event.removeAllTagsFrom(id);
    event.add("c:hidden_from_recipe_viewers", id);
  });

  event.removeAllTagsFrom("immersiveengineering:storage_steel");

  event.remove("c:ingots/aluminum", ["xycraft_world:aluminum_ingot"]);
  event.remove("c:nuggets/aluminum", ["xycraft_world:aluminum_nugget"]);
  event.remove("c:storage_blocks/aluminum", ["xycraft_world:aluminum_storage"]);
  event.remove("c:raw_materials/aluminum", ["xycraft_world:raw_aluminum"]);
  event.remove("c:raw_materials/raw_aluminum", [
    "xycraft_world:raw_aluminum_block",
  ]);

  event.add("c:ingots/xy_aluminum", ["xycraft_world:aluminum_ingot"]);
  event.add("c:nuggets/xy_aluminum", ["xycraft_world:aluminum_nugget"]);
  event.add("c:storage_blocks/xy_aluminum", ["xycraft_world:aluminum_storage"]);
  event.add("c:raw_materials/xy_aluminum", ["xycraft_world:raw_aluminum"]);
  event.add("c:storage_blocks/xy_raw_aluminum", [
    "xycraft_world:raw_aluminum_block",
  ]);

  //Removing Malum's Knifes to fix certain Recipes.
  const malum_knifes = ["malum:soul_stained_steel_knife", "malum:sundering_anchor"];
  const malum_axes = ["malum:soul_stained_steel_axe", "malum:weight_of_worlds"];
  malum_knifes.forEach(knife => {
    event.remove("c:tools/knife", knife);
    event.remove("farmersdelight:tools/knives", knife);
  });
  malum_axes.forEach(axe => {
    event.remove("minecraft:axes", axe);
  });

  //remove spawn eggs
  event.remove(
    "ftbevolution:spawn_eggs",
    "productivebees:spawn_egg_configurable_bee"
  );
  [
    "ars_nouveau:whirlisprig_se",
    "ars_nouveau:wilden_guardian_se",
    "ars_nouveau:wilden_hunter_se",
    "ars_nouveau:wilden_stalker_se",
  ].forEach((item) => event.add("ftbevolution:spawn_eggs", item));

  //Adding Rechiseled Planks to Specific Tags
  rechiseled_acacia.forEach((plank) => {
    event.add("rechiseled:acacia_planks", plank);
  });
  rechiseled_oak.forEach((plank) => {
    event.add("rechiseled:oak_planks", plank);
  });
  rechiseled_spruce.forEach((plank) => {
    event.add("rechiseled:spruce_planks", plank);
  });
  rechiseled_birch.forEach((plank) => {
    event.add("rechiseled:birch_planks", plank);
  });
  rechiseled_jungle.forEach((plank) => {
    event.add("rechiseled:jungle_planks", plank);
  });
  rechiseled_dark_oak.forEach((plank) => {
    event.add("rechiseled:dark_oak_planks", plank);
  });
  rechiseled_mangrove.forEach((plank) => {
    event.add("rechiseled:mangrove_planks", plank);
  });
  rechiseled_cherry.forEach((plank) => {
    event.add("rechiseled:cherry_planks", plank);
  });
  rechiseled_bamboo.forEach((plank) => {
    event.add("rechiseled:bamboo_planks", plank);
  });
  rechiseled_crimson.forEach((plank) => {
    event.add("rechiseled:crimson_planks", plank);
  });
  rechiseled_warped.forEach((plank) => {
    event.add("rechiseled:warped_planks", plank);
  });

  //Adding All Vanilla Planks to a specific Tag ===================================================

  //First Adding from Other Plank OreDicts
  event.add("ftbevolution:vanilla_planks", "#chipped:oak_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:spruce_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:birch_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:jungle_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:acacia_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:dark_oak_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:mangrove_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:cherry_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:bamboo_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:crimson_planks");
  event.add("ftbevolution:vanilla_planks", "#chipped:warped_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:oak_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:spruce_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:birch_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:jungle_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:acacia_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:dark_oak_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:mangrove_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:cherry_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:bamboo_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:crimson_planks");
  event.add("ftbevolution:vanilla_planks", "#rechiseled:warped_planks");

  //Second Adding from Lists
  vanillaPlanks.forEach((plank) => {
    event.add("ftbevolution:vanilla_planks", plank);
  });
  productive_planks.forEach((plank) => {
    event.add("ftbevolution:productive_planks", plank);
  });
  bwg_planks.forEach((plank) => {
    event.add("ftbevolution:bwg_planks", plank);
  });
  bwg_crafting_tables.forEach((table) => {
    event.add("ftbevolution:bwg_crafting_tables", table);
  });
  // ==============================================================================================

  ender_pearl_variations.forEach((pearl) => {
    event.add("ftbevolution:ender_pearl_variations", pearl);
  });

  //Tanks Tag
  let modpack_tanks = [
    'mekanism:basic_fluid_tank',
    'mekanism:advanced_fluid_tank',
    'mekanism:elite_fluid_tank',
    'mekanism:ultimate_fluid_tank',
    'modern_industrialization:iron_tank',
    'modern_industrialization:bronze_tank',
    'modern_industrialization:steel_tank',
    'modern_industrialization:aluminum_tank',
    'modern_industrialization:stainless_steel_tank',
    'modern_industrialization:titanium_tank',
    'modern_industrialization:quantum_tank',
    'pneumaticcraft:huge_tank',
    'pneumaticcraft:large_tank',
    'pneumaticcraft:medium_tank',
    'pneumaticcraft:small_tank',
    'dimstorage:dimensional_tank',
    'oritech:small_tank_block',
    'enderio:pressurized_fluid_tank',
    'enderio:fluid_tank',
    'mob_grinding_utils:jumbo_tank',
    'mob_grinding_utils:tank'
  ]

  modpack_tanks.forEach(tank => {
    event.add("ftbevolution:tanks", tank);
  });

  //Adding a General Quartz Dust Tag
  event.add("ftbevolution:quartz_dust", ['ftbmaterials:quartz_dust', 'jaopca:dusts.black_quartz', 'ae2:certus_quartz_dust']);

  //Adding Black Quartz to the All Quartz AE Tag.
  event.add("ae2:all_quartz", "actuallyadditions:black_quartz");

  //Adding Oritech's Biosteel Block to the Steel OreDicts/Tags (Unification Fixes can be found at Oritech.js)
  event.add("c:storage_blocks/steel", 'oritech:biosteel_block');
  //event.add("c:dusts/steel", 'oritech:biosteel_dust'); BioSteel Dusts adds too many recipes problems to be addressed.

  //Fixing MoreRed Red Alloy
  event.remove('c:ingots/redstone_alloy', 'morered:red_alloy_ingot');
  event.add("c:ingots/red_alloy", ['morered:red_alloy_ingot', 'enderio:redstone_alloy_ingot']);

  //Adding our Custom Ruby Gem to the Ruby Gem Tag
  event.add('productivebees:flowers/ruby', 'ftbevolution:ruby_gem');
	event.add('c:gems/ruby', 'ftbevolution:ruby_gem');

  //Adding a Tag to allow 2x Compressed Charcoal Blocks to accept both Meka's and Compressed Block's Charcoal Blocks.
  event.add('ftb:compacted_charcoal', 'mekanism:block_charcoal');
  event.add('ftb:compacted_charcoal', 'compressedblocks:crated_charcoal');

  //Adding the Correct Brick Tag to Vanilla Bricks.
  event.add("c:ingots/brick", "minecraft:brick");

  //Adding Oritech Clumps to the Universal Clump Tag.
  event.add("c:clumps/tin", 'jaopca:oritech_clumps.tin');
  event.add("c:clumps/lead", 'jaopca:oritech_clumps.lead');
  event.add("c:clumps/osmium", 'jaopca:oritech_clumps.osmium');

  //Adding a Blackthorn Wood Tag
  event.add("c:logs/black_thorn", "paganbless:black_thorn_log");
  event.add("c:stripped_logs/black_thorn", "paganbless:stripped_black_thorn_log");
  event.add("c:woods/black_thorn", "paganbless:black_thorn_wood");
  event.add("c:stripped_woods/black_thorn", "paganbless:stripped_black_thorn_wood");
  event.add("c:planks/black_thorn", "paganbless:black_thorn_planks");
  event.add("c:slabs/black_thorn", "paganbless:black_thorn_slab");
  event.add("c:stairs/black_thorn", "paganbless:black_thorn_stairs");
  event.add("c:fences/black_thorn", "paganbless:black_thorn_fence");
  event.add("c:fence_gates/black_thorn", "paganbless:black_thorn_fence_gate");
  event.add("c:pressure_plates/black_thorn", "paganbless:black_thorn_pressure_plate");
  event.add("c:buttons/black_thorn", "paganbless:black_thorn_button");
  event.add("c:doors/black_thorn", "paganbless:black_thorn_door");
  event.add("c:trapdoors/black_thorn", "paganbless:black_thorn_trapdoor");

  event.add("c:logs/black_thorn", "productivetrees:blackthorn_log");
  event.add("c:stripped_logs/black_thorn", "productivetrees:blackthorn_log");
  event.add("c:woods/black_thorn", "productivetrees:blackthorn_wood");
  event.add("c:stripped_woods/black_thorn", "productivetrees:blackthorn_wood");
  event.add("c:planks/black_thorn", "productivetrees:blackthorn_planks");
  event.add("c:slabs/black_thorn", "productivetrees:blackthorn_slab");
  event.add("c:stairs/black_thorn", "productivetrees:blackthorn_stairs");
  event.add("c:fences/black_thorn", "productivetrees:blackthorn_fence");
  event.add("c:fence_gates/black_thorn", "productivetrees:blackthorn_fence_gate");
  event.add("c:pressure_plates/black_thorn", "productivetrees:blackthorn_pressure_plate");
  event.add("c:buttons/black_thorn", "productivetrees:blackthorn_button");
  event.add("c:doors/black_thorn", "productivetrees:blackthorn_door");
  event.add("c:trapdoors/black_thorn", "productivetrees:blackthorn_trapdoor");
  // ======= //

});

ServerEvents.tags("block_entity_type", (event) => {
  arsBlacklist.forEach((block) => {
    event.get("craftingstation:blacklisted").add(block);
  });
  event.add("craftingstation:blacklisted", "@mekanism")
});

ServerEvents.tags("block", (event) => {

  //remove globally ununified blocks (not adding the hiding tag since this is done in the item tags event.)
  global["unUnified"].forEach((id) => {
    event.removeAllTagsFrom(id);
  });

  factoryBlocks.forEach((factoryBlock) => {
    event.add("minecraft:mineable/pickaxe", factoryBlock);
  });

  //Temp Tag addition until its fixed by the Mystical Agriculture Dev
  event.add("minecraft:mineable/pickaxe", 'mysticalagriculture:awakened_supremium_growth_accelerator');
  
  //Why Forbidden Arcanus is so broken? Adding a Tag so this block can be properly broken.
  event.add("minecraft:mineable/pickaxe", "forbidden_arcanus:arcane_crystal_block");


  arsBlacklist.forEach((block) => {
    event.get("ars_nouveau:no_break_drop").add(block);
  });

  event.add("justdirethings:lawnmowerable", [
    "#projectvibrantjourneys:groundcover",
  ]);
  event.add("minecraft:beacon_base_blocks", [
    "ftbevolution:pyramid_base",
    "ftbevolution:pyra_mid_lower",
    "ftbevolution:pyra_mid_upper",
    "ftbevolution:pyramid_top",
  ]);

  addLawnmowerable.forEach((block) =>
    event.add("justdirethings:lawnmowerable", block)
  );
  event.add("ftbchunks:interact_whitelist", ["@waystones"]);

  relocation_not_supported.forEach(block => {
    event.add("c:relocation_not_supported", block);
  });

});

ServerEvents.tags("fluid", (event) => {
  event.add("c:ethanol", ["modern_industrialization:ethanol"]);
  event.add("c:boostedbiodiesel", [
    "modern_industrialization:boosted_biodiesel",
  ]);
  event.add("c:crystallized_oil", ["actuallyadditions:crystallized_oil"]);
  event.add("c:empowered_oil", ["actuallyadditions:empowered_oil"]);
  event.add("c:plantoil", ["modern_industrialization:plant_oil"]);
  event.add("c:synthetic_oil", ["modern_industrialization:synthetic_oil"]);
  event.add("c:biodiesel", ["modern_industrialization:biodiesel"]);
  event.add("c:polyethylene", ["modern_industrialization:polyethylene"]);
  event.add("c:lubricant", ["modern_industrialization:lubricant"]);
  event.add("c:crude_oil", ["modern_industrialization:crude_oil"]);
  event.add("c:crude_oil", ["oritech:still_oil"]);
  event.add("c:fuels/crude_oil", ["oritech:still_oil"]);
  event.add("c:fuels/crude_oil", ["modern_industrialization:crude_oil"]);
  event.add("c:diesel", ["modern_industrialization:diesel"]);
  event.add("c:boosteddiesel", ["modern_industrialization:boosted_diesel"]);
  event.add("c:forceddiesel", ["ftbneotech:force_infused_diesel"]);
  event.add("c:hydrogen", ["modern_industrialization:hydrogen"]);
  event.add("c:oxygen", ["modern_industrialization:oxygen"]);
  event.add("c:chlorine", ["modern_industrialization:chlorine"]);
  event.add("c:sulfuric_acid", ["modern_industrialization:sulfuric_acid"]);
  event.add("c:ethylene", ["modern_industrialization:ethylene"]);
  event.add("c:ethene", ["modern_industrialization:ethylene"]);
  event.add("c:heavy_water", ["modern_industrialization:heavy_water"]);
  event.add("c:refinedcanola", ["actuallyadditions:refined_canola_oil"]);
  event.add("c:hydrogen", ["modern_industrialization:hydrogen"]);
  event.add("c:hydrogen", ["mekanism:hydrogen"]);
  event.add("c:oxygen", ["modern_industrialization:oxygen"]);
  event.add("c:oxygen", ["mekanism:oxygen"]);
  event.add("c:chlorine", ["modern_industrialization:chlorine"]);
  event.add("c:chlorine", ["mekanism:chlorine"]);
  event.add("c:sulfuric_acid", ["modern_industrialization:sulfuric_acid"]);
  event.add("c:sulfuric_acid", ["mekanism:sulfuric_acid"]);
  event.add("c:ethylene", ["modern_industrialization:ethylene"]);
  event.add("c:ethene", ["mekanism:ethene"]);
  event.add("c:steam", ["modern_industrialization:steam"]);
  event.add("c:heavy_water", ["modern_industrialization:heavy_water"]);
  event.add("c:heavy_water", ["mekanism:heavy_water"]);
  event.add("c:deuterium", ["modern_industrialization:deuterium"]);
  event.add("c:deuterium", ["mekanism:deuterium"]);
  event.add("c:tritium", ["modern_industrialization:tritium"]);
  event.add("c:tritium", ["mekanism:tritium"]);
  event.add("c:diesel", ["modern_industrialization:diesel"]);
  event.add("c:fuels/diesel", ["modern_industrialization:diesel"]);
  event.add("c:fuels/biodiesel", ["modern_industrialization:biodiesel"]);
  event.add("c:fuels/ethanol", ["modern_industrialization:ethanol"]);
  event.add("c:oil", ["modern_industrialization:crude_oil"]);
  event.add("c:oil", ["pneumaticcraft:oil"]);
  

  //Adding Extended MI's Honey to a proper Tag.
  event.add("c:honey", ["extended_industrialization:honey"]);

  //Removing Tags
  event.remove("c:water", ["oritech:still_oil"]);
  event.remove("c:steam", ["mekanism:steam"]);
  event.remove("c:gaseous", ["mekanism:steam"]);
  event.remove("c:steam", ["mekanism:flowing_steam"]);
  event.remove("c:gaseous", ["mekanism:flowing_steam"]);
  
  //Hiding Fluids
  yeeted_fluids.forEach(fluid => {
    event.removeAllTagsFrom(fluid);
    event.add("c:hidden_from_recipe_viewers", [fluid]);
  });

});

const chunkBlacklist = [
  "endermanoverhaul:badlands_enderman",
  "endermanoverhaul:cave_enderman",
  "endermanoverhaul:coral_enderman",
  "endermanoverhaul:crimson_forest_enderman",
  "endermanoverhaul:dark_oak_enderman",
  "endermanoverhaul:desert_enderman",
  "endermanoverhaul:end_enderman",
  "endermanoverhaul:end_islands_enderman",
  "endermanoverhaul:flower_fields_enderman",
  "endermanoverhaul:ice_spikes_enderman",
  "endermanoverhaul:mushroom_fields_enderman",
  "endermanoverhaul:nether_wastes_enderman",
  "endermanoverhaul:savanna_enderman",
  "endermanoverhaul:snowy_enderman",
  "endermanoverhaul:swamp_enderman",
  "endermanoverhaul:soulsand_valley_enderman",
  "endermanoverhaul:warped_forest_enderman",
  "endermanoverhaul:windswept_hills_enderman",
  "ae2:tiny_tnt_primed"
]

ServerEvents.tags("entity_type", (event) => {
  chunkBlacklist.forEach((chunk) => {
    event.get("ftbchunks:entity_mob_griefing_blacklist").add(chunk);
  });
  event.add("minecraft:breeze", ["minecraft:breeze"]);
  event.add("justdirethings:paradox_deny", /productivebees:/);
  event.add("industrialforegoing:mob_duplicator_blacklist", /productivebees:/);
  magicMobs.forEach((mobs) => {
    event.get("ftbevolution:magicmobs").add(mobs);
  });
  event.add("ftbevolution:magicmobs", "#ars_nouveau:magic_find");

	//Adding Productive Bees to Apoth's Spawner Blacklist
	event.add("apothic_spawners:blacklisted_from_spawners", /productivebees:/);

	event.add("apothic_spawners:blacklisted_from_spawners", "minecraft:wither");

});
