// priority: 999

ServerEvents.recipes((event) => {

  const stonecutting = event.stonecutting;
  var transmute = function (arrayOfBlocks) {
    var cpt = 0;
    while (cpt < arrayOfBlocks.length) {
      var otherBlocks = arrayOfBlocks.slice(0, cpt).concat(arrayOfBlocks.slice(cpt + 1));
      stonecutting(arrayOfBlocks[cpt], otherBlocks);
      cpt++;
    }
  };

  //Adding Stonecutter Conversion Recipes for Duplicated Blocks ===================================

  //SourceBerry Sack and Crate
  transmute(["ars_nouveau:sourceberry_sack", "arsdelight:source_berry_crate"]);
  //Steel Blocks
  transmute(["ftbmaterials:steel_block", "immersiveengineering:storage_steel"]);
  //Sugar Blocks
  transmute(["compressedblocks:crated_sugar", "supplementaries:sugar_cube"]);
  //Honeycomb and Carvable Wax Blocks
  transmute(["the_bumblezone:carvable_wax", "compressedblocks:crated_honeycomb"]);
  //Brass Blocks
  transmute(["create:brass_block", "ftbmaterials:brass_block"]);
  //Zinc Blocks
  transmute(["create:zinc_block", "ftbmaterials:zinc_block"]);
  //Raw Zinc Blocks
  transmute(["create:raw_zinc_block", "ftbmaterials:zinc_raw_block"]);
  //Crate of Apples
  transmute(["compressedblocks:crated_apple", "productivetrees:red_delicious_apple_crate"]);
  //Crate of Beets
  transmute(["compressedblocks:crated_beetroot", "farmersdelight:beetroot_crate"]);
  //Crate of Potatoes
  transmute(["compressedblocks:crated_potato", "farmersdelight:potato_crate"]);
  //Crate of Carrots
  transmute(["compressedblocks:crated_carrot", "farmersdelight:carrot_crate"]);
  //Feather Blocks
  transmute(["compressedblocks:crated_feather", "supplementaries:feather_block"]);
  //Charcoal Blocks
  transmute(["compressedblocks:crated_charcoal", "mekanism:block_charcoal"]);
  //Allium Blocks
  transmute(["compressedblocks:crated_allium", "biomeswevegone:allium_petal_block"]);
  
  // ==============================================================================================

  //Allowing Mekanism's Charcoal Blocks to be used in the 2X Compressed Charcoal Recipe.
  event.replaceInput(
    { id: "compressedblocks:shaped_double_crated_charcoal" },
    "compressedblocks:crated_charcoal",
    "#ftb:compacted_charcoal"
  );

  //Adding Meka Charcoal Block Compact with Compressed Blocks.
  event.custom({
    type: "functionalstorage:custom_compacting",
    higher_input: {
      count: 1,
      id: "compressedblocks:double_crated_charcoal"
    },
    lower_input: {
      count: 9,
      id: "mekanism:block_charcoal"
    },
  });

  //Adding Tiny Coals Compat with Compacting Drawers ==============================================

  //Coal
  event.custom({
    type: "functionalstorage:custom_compacting",
    higher_input: {
      count: 1,
      id: "minecraft:coal"
    },
    lower_input: {
      count: 8,
      id: "actuallyadditions:tiny_coal"
    },
  });

  //Charcoal
  event.custom({
    type: "functionalstorage:custom_compacting",
    higher_input: {
      count: 1,
      id: "minecraft:charcoal"
    },
    lower_input: {
      count: 8,
      id: "actuallyadditions:tiny_charcoal"
    },
  });

  // ==============================================================================================

  //for enderman overhaul compat
  event
    .shapeless(`minecraft:ender_pearl`, [
      `#ftbevolution:ender_pearl_variations`,
    ])
    .id(`ftbevolution:pearl_conversion`);

  // Antimony Conversion
  // event
  //   .shapeless("ftbmaterials:antimony_ingot", "modern_industrialization:antimony_ingot")
  //   .id(`ftbevolution:antimony_conversion`);

  //Osmium Fix
  event
    .shapeless(`9x ftbmaterials:osmium_raw_ore`, "ftbmaterials:osmium_raw_block")
    .id(`ftbevolution:raw_osmium_block_conversion`);
  
  event
    .shapeless(`8x actuallyadditions:tiny_coal`, [`minecraft:coal`])
    .id(`ftbevolution:tiny_coal`);

  event
    .shapeless(`8x actuallyadditions:tiny_charcoal`, [`minecraft:charcoal`])
    .id(`ftbevolution:tiny_charcoal`);

    event.custom({
      "type": "functionalstorage:custom_compacting",
      "higher_input": {
        "count": 1,
        "id": 'minecraft:honeycomb_block'
      },
      "lower_input": {
        "count": 4,
        "id": 'minecraft:honeycomb'
      }
    }).id("functionalstorage:compacting/honeycomb_block")
    

  event
    .shapeless(
      "ftbmaterials:steel_plate",
      [
        "ftbmaterials:steel_ingot",
        "immersiveengineering:hammer"
      ]
    )
    .id("ftbevolution:steel_plate_hammer");
    
  event
    .shapeless(`9x minecraft:redstone`, [`#c:storage_blocks/redstone`])
    .id(`ftbevolution:redstone_conversion`);
  event
    .shaped("utilitarian:redstone_clock", ["SRS", "RTR", "SRS"], {
      S: "#c:stones",
      R: "#c:dusts/redstone",
      T: "minecraft:redstone_torch",
    })
    .id("ftbevolution:redstone_clock");

  event
    .shaped("ftbmaterials:platinum_raw_ore", ["EEE", "E E", "EEE"], {
      E: "mysticalagriculture:platinum_essence",
    })
    .id("ftbevolution:platinum");

  event
    .shaped("8x ae2:silicon", ["   ", "EEE", "   "], {
      E: "mysticalagriculture:silicon_essence",
    })
    .id("ftbevolution:silicon");

  //diamond gear
  event
    .shaped("ftbmaterials:diamond_gear", [" D ", "DGD", " D "], {
      D: "minecraft:diamond",
      G: "ftbmaterials:iron_gear",
    })
    .id("ftbevolution:diamond_gear");

    //Elytra Dupe
    event
  .shaped("minecraft:elytra", ["DED", "DGD", "DDD"], {
    D: "minecraft:phantom_membrane",
    E: "minecraft:dragon_egg",
    G: 'minecraft:elytra',
  })
  .id("ftbevolution:elytra_dupe").keepIngredient('minecraft:elytra');

  //Additional Xy's Dust Recipes ==================================================================

    //Adding a Crusher Recipe for Xy's Aluminum
    event.custom({
      "type": "immersiveengineering:crusher",
      "energy": 3000,
      "input": {
        "tag": "c:ingots/xy_aluminum"
      },
      "result": {
        "tag": "c:dusts/xy_aluminum"
      }
    }).id("ftbevolution:xy_aluminum_dust_crushing");
    
  // ==============================================================================================

  const cookedMaterials = [
    {
      output: "ftbmaterials:tin_ingot",
      input: "#c:raw_materials/tin",
      id: "tin",
    },
    {
      output: "ftbmaterials:osmium_ingot",
      input: "#c:raw_materials/osmium",
      id: "osmium",
    },
    {
      output: "xycraft_world:aluminum_ingot",
      input: "#c:ores/aluminum",
      id: "aluminum_ore",
    },
    {
      output: "ftbmaterials:lead_ingot",
      input: "#c:raw_materials/lead",
      id: "lead",
    },
    {
      output: "ftbmaterials:lead_ingot",
      input: "#c:ores/lead",
      id: "lead_ore",
    },
    {
      output: "ftbmaterials:silver_ingot",
      input: "#c:ores/silver",
      id: "silver_ore",
    },
    {
      output: "ftbmaterials:nickel_ingot",
      input: "#c:raw_materials/nickel",
      id: "nickel",
    },
    {
      output: "ftbmaterials:nickel_ingot",
      input: "#c:ores/nickel",
      id: "nickel_ore",
    }
  ];

  cookedMaterials.forEach((material) => {
    event
      .smelting(material.output, material.input)
      .xp(0.5)
      .id(`ftbevolution:smelt_${material.id}`);

    event
      .blasting(material.output, material.input)
      .id(`ftbevolution:blasting_${material.id}`);
  });

  event
    .smelting(
      "9x xycraft_world:aluminum_ingot",
      "#c:storage_blocks/xy_raw_aluminum"
    )
    .xp(0.5)
    .id("ftbevolution:smelt_raw_aluminum");

  event
    .shaped("functionalstorage:dripping_upgrade", ["dsd", "rir", "dld"], {
      d: "#c:ore_bearing_ground/deepslate",
      s: "minecraft:pointed_dripstone",
      r: "#c:dusts/redstone",
      i: "enderio:grains_of_infinity",
      l: "mcwlights:lava_lamp",
    })
    .id("ftbevolution:dripping_upgrade");

  event
    .shaped(
      "modern_industrialization:steam_mining_drill",
      ["fdd", "PDd", "bPf"],
      {
        P: "ftbmaterials:iron_plate",
        f: "minecraft:furnace",
        b: "minecraft:bucket",
        d: "minecraft:diamond",
        D: "modern_industrialization:copper_drill_head",
      }
    )
    .id("ftbevolution:steam_mining_drill");

  //explorer's compass
  event
    .shaped("explorerscompass:explorerscompass", ["BAB", "ACA", "BAB"], {
      A: "ftbmaterials:netherite_nugget",
      B: "minecraft:amethyst_shard",
      C: "ftbmaterials:diamond_gear",
    })
    .id("ftbevolution:explorerscompass");

  event
    .shaped("paganbless:black_thorn_sapling", ["SD ", "DD ", "   "], {
      S: "minecraft:oak_sapling",
      D: "#c:dyes/black",
    })
    .id("ftbevolution:black_thorn_sapling");

  //fix Patchouli books
  event.shapeless(
    Item.of(
      'patchouli:guide_book[patchouli:book="irons_spellbooks:iss_guide_book"]'
    ),
    ["minecraft:book", "irons_spellbooks:arcane_essence"]
  );
  event.shapeless(
    Item.of('patchouli:guide_book[patchouli:book="mysticalagriculture:guide"]'),
    ["minecraft:book", "mysticalagriculture:inferium_essence"]
  );

  event
    .shapeless(
      'mekanism:creative_energy_cube[mekanism:side_config={config:{energy:{eject:1b,side:{back:"output",bottom:"output",front:"output",left:"output",right:"output",top:"output"}},items:{side:{back:"input",bottom:"input",front:"output",left:"input",right:"input",top:"input"}}}},mekanism:energy={energy_containers:[L;9223372036854775807L]}]',
      ["mekanism:basic_energy_cube", "ftbevolution:creative_ascension"]
    )
    .id("ftbevolution:creative_energy_cube");
  event
    .shapeless("xycraft_machines:fluid_selector", [
      "xycraft_machines:extractor",
      "ftbevolution:creative_ascension",
      "xycraft_machines:valve",
    ])
    .id("ftbevolution:creative_fluid_selector");
  event
    .shapeless("xycraft_machines:item_selector", [
      "xycraft_machines:extractor",
      "ftbevolution:creative_ascension",
      "xycraft_machines:soaryn_box",
    ])
    .id("ftbevolution:creative_item_selector");

  event
    .shapeless(
      "mekanism:elite_control_circuit",
      "modern_industrialization:analog_circuit"
    )
    .id("ftbevolution:elite_control_circuit");
  event
    .shapeless(
      "modern_industrialization:analog_circuit",
      "mekanism:elite_control_circuit"
    )
    .id("ftbevolution:elite_control_circuit_rev");
  event
    .shapeless(
      "mekanism:ultimate_control_circuit",
      "modern_industrialization:electronic_circuit"
    )
    .id("ftbevolution:ultimate_control_circuit");
  event
    .shapeless(
      "modern_industrialization:electronic_circuit",
      "mekanism:ultimate_control_circuit"
    )
    .id("ftbevolution:ultimate_control_circuit_rev");
  event
    .shapeless("ae2:creative_energy_cell", [
      "ae2:energy_acceptor",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_energy_cell");
  event
    .shapeless(
      'ironjetpacks:jetpack[ironjetpacks:jetpack_id="ironjetpacks:creative",rarity="epic"]',
      [
        'ironjetpacks:jetpack[ironjetpacks:jetpack_id="ironjetpacks:wood"]',
        "ftbevolution:creative_ascension",
      ]
    )
    .id("ftbevolution:creative_jetpack");
  event
    .shapeless("fargostalismans:soul_of_flight_mastery", [
      "fargostalismans:abominable_energy",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_soul_of_flight");
  event
    .shapeless("mekanism:creative_chemical_tank", [
      "mekanism:basic_chemical_tank",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_chemical_tank");
  event
    .shapeless("pneumaticcraft:creative_compressed_iron_block", [
      "pneumaticcraft:compressed_iron_block",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_compressed_iron_block");
  event
    .shapeless("pneumaticcraft:creative_compressor", [
      "pneumaticcraft:manual_compressor",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_compressor");
  event
    .shapeless("ars_nouveau:creative_source_jar", [
      "ars_nouveau:source_jar",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_source_jar");
  event
    .shapeless("mysticalagriculture:creative_soulium_dagger", [
      "mysticalagriculture:soulium_dagger",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_soulium_dagger");
  event
    .shapeless("cabletiers:creative_importer", [
      "#refinedstorage:importers",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_importer");
    event
    .shapeless("cabletiers:creative_exporter", [
      "#refinedstorage:exporters",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_exporter");
    event
    .shapeless("cabletiers:creative_constructor", [
      "#refinedstorage:constructors",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_constructor");
    event
    .shapeless("cabletiers:creative_destructor", [
      "#refinedstorage:destructors",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_destructor");
    event
    .shapeless("cabletiers:creative_disk_interface", [
      "#refinedstorage:disk_interfaces",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_disk_interface");
    
  event
    .custom({
      type: "immersiveengineering:alloy",
      input0: {
        tag: "c:gems/amethyst",
      },
      input1: {
        item: "simpleteleporters:ender_shard",
      },
      result: {
        basePredicate: {
          item: "the_afterdark:teleport_catalyst",
        },
        count: 1,
      },
    })
    .id("ftbevolution:teleport_catalyst");

  event
    .custom({
      type: "enderio:alloy_smelting",
      energy: 2000,
      experience: 0.3,
      inputs: [
        {
          count: 1,
          tag: "c:gems/amethyst",
        },
        {
          count: 1,
          item: "simpleteleporters:ender_shard",
        },
      ],
      output: {
        count: 1,
        id: "the_afterdark:teleport_catalyst",
      },
    })
    .id("ftbevolution:teleport_catalyst_alloy_smelting");

  event
    .custom({
      type: "treetap:tap_extract",
      log: {
        item: "integrateddynamics:menril_log",
      },
      processing_time: 1200,
      result: {
        id: "integrateddynamics:bucket_menril_resin",
      },
      collect_bucket: true,
      display_fluid: {
        fluid: "integrateddynamics:menril_resin",
      },
      fluid_color: "#00eaff",
    })
    .id("ftbevolution:menril_resin");

  event
    .shapeless("ftbmaterials:copper_dust", "mekanism:dust_copper")
    .id("ftbevolution:copper_dust_exchange");

  //Adding Constantan Dust to Ingot Smelting Recipes.
  event.smelting('ftbmaterials:constantan_ingot', '#c:dusts/constantan')
  event.blasting('ftbmaterials:constantan_ingot', '#c:dusts/constantan')
  event.custom({type: "enderio:alloy_smelting",energy: 1500,experience: 0.3,inputs: [{count: 1,tag: 'c:dusts/constantan',}],output: {count: 1,id: 'ftbmaterials:constantan_ingot',}}).id("ftbevolution:alloy_smelting/constantan_ingot_from_dust");

  //Adding Conversion Recipes for MI Villager Ingots into FTB Materials Ingots
  
  let mi_villager_ingots = [
  ["ftbmaterials:tin_ingot", "modern_industrialization:tin_ingot"],
  ["ftbmaterials:bronze_ingot", "modern_industrialization:bronze_ingot"],
  ["ftbmaterials:steel_ingot", "modern_industrialization:steel_ingot"],
  ["ftbmaterials:sulfur_dust", "modern_industrialization:sulfur_dust"],
  ]; 

  mi_villager_ingots.forEach(ingot => {

    let output_name = ingot[1].split(":");

      event.shapeless(
        Item.of(ingot[0], 1),
        [
          ingot[1]
        ]
     ).id("ftbevolution:conversion/mi_villager/materials/" + output_name[1]);
  });

  //Adding a Alternative Recipe to Torchflower Seeds
  event.shaped(
    Item.of('minecraft:torchflower_seeds', 1),
    [
      'VVV',
      'VTV',
      'T T'
    ],
    {
      T: 'reliquary:interdiction_torch',
      V: '#chipped:vine'
    }
  ).id("ftbevolution:torchberry_seeds");

  //Readding Create Milling Integration Recipes =================================================

  const milling_recipes = [
      {input: "farmersdelight:rice_panicle", outputs: [{"id": "farmersdelight:rice"}, {"id": "farmersdelight:straw"}]},
      {input: "farmersdelight:wild_beetroots", outputs: [{"id": "minecraft:beetroot_seeds"}, {"id": "minecraft:red_dye"}]},
      {input: "farmersdelight:wild_cabbages", outputs: [{"id": "farmersdelight:cabbage_seeds"}, {"id": "minecraft:yellow_dye"}]},
      {input: "farmersdelight:wild_carrots", outputs: [{"id": "minecraft:light_gray_dye"}, {"id": "minecraft:lime_dye"}]},
      {input: "farmersdelight:wild_onions", outputs: [{"id": "minecraft:magenta_dye", "count": 1}, {"id": "minecraft:magenta_dye", "count": 3, "chance": 0.2}, {"id": "minecraft:lime_dye", "count": 1, "chance": 0.1}]},
      {input: "farmersdelight:wild_potatoes", outputs: [{"id": "minecraft:purple_dye", "count": 2}, {"id": "minecraft:lime_dye", "count": 1, "chance": 0.1}]},
      {input: "farmersdelight:wild_rice", outputs: [{"id": "farmersdelight:rice", "count": 1}, {"id": "farmersdelight:straw", "count": 1, "chance": 0.5}]},
      {input: "farmersdelight:wild_tomatoes", outputs: [{"id": "farmersdelight:tomato_seeds","count": 1}, {"id": "minecraft:green_dye","count": 1}]}
  ];

  milling_recipes.forEach(recipe => {
      let id = recipe.input.split(":")[1]
      event.custom({
          "type": "create:milling",
          "ingredients": [
              {
                  "item": recipe.input
              }
          ],
          "processing_time": 60,
          "results": recipe.outputs
      }).id(`ftb:create/crushing/farmers_delight/${id}`);
  });

  //Adding a Specific Recipe for Pagan Bless's Blackthorn Sticks
  event.shaped(
    Item.of("paganbless:black_thorn_stick", 4),
    [
      "P",
      "P"
    ],
    {
      P: "#c:planks/black_thorn"
    }
  ).id("ftbevolution:paganbless/black_thorn_sticks");

  event.shaped(
    Item.of("paganbless:black_thorn_stick", 16),
    [
      "P",
      "P"
    ],
    {
      P: "#c:logs/black_thorn"
    }
  ).id("ftbevolution:paganbless/black_thorn_sticks_with_logs");

  //GeOre Processing ===
  const GeOre_Processing = [
    {input: '#geore:geore_shards/aluminum', output: 'xycraft_world:aluminum_ingot', xp: 0.7},
    {input: '#geore:geore_shards/platinum', output: 'ftbmaterials:platinum_raw_ore', xp: 0.7},
    {input: '#geore:geore_shards/tungsten', output: 'ftbmaterials:tungsten_raw_ore', xp: 0.7},
  ];

  GeOre_Processing.forEach(recipe => {
    event.smelting(recipe.output, recipe.input).xp(recipe.xp);
    event.blasting(recipe.output, recipe.input).xp(recipe.xp);
  });

  //Alu Recipes
  event.custom({
    "type": "immersiveengineering:arc_furnace",
    "additives": [],
    "energy": 25600,
    "input": {
        "tag": "geore:geore_shards/aluminum"
    },
    "results": [
        { 
        "item": "ftbmaterials:aluminum_ingot"
        }
    ],
    "time": 100
  }).id("ftb:arc_aluminum_from_geore_shard");

  event.custom({
    "type": "modern_industrialization:blast_furnace",
    "duration": 200,
    "eu": 32,
    "item_inputs": [
      {
        "amount": 1,
        "tag": "geore:geore_shards/aluminum"
      }
    ],
    "item_outputs": [
      {
        "amount": 1,
        "item": "ftbmaterials:aluminum_ingot"
      }
    ]
  }).id("ftb:aluminum_from_geore_shard");

  event.shapeless(
    Item.of("ftbmaterials:steel_ingot", 9),
   [
    "ftbmaterials:steel_block"
   ]
  ).id("ftb:shapeless/steel_ingot_from_block");

});
