// priority: 994

EntityEvents.spawned(event => {   
    const { entity, level } = event;


    if (!entity.isLiving()) return;
    if(entity.isPlayer()) return;
    const buffBiomes = [
        "infinity_cave:amethyst_caves",
        "infinity_cave:deeprock_caverns",
        "infinity_cave:frozen_caves",
        "infinity_cave:limestone_grotto",
        "infinity_cave:molten_caves",
        "infinity_cave:sulfide_caves",
        "minecraft:deep_dark",
        "the_afterdark:calcite_fields",
        "the_afterdark:creepy_snowfields",
        "the_afterdark:deep_afterdark",
        "the_afterdark:dripstone_deltas",
        "the_afterdark:dying_drylands",
        "the_afterdark:lush_gardens",
        "the_afterdark:prismarine_peaks",
        "the_afterdark:prismarine_ponds"
    ];

    if (!buffBiomes.includes(event.entity.block.biomeId.toString())){
        // console.log('Entity spawned in non-buff biome:' + event.entity.block.biomeId.toString());
        return;
    } 
    // console.log('Entity spawned in buff biome');


    let ePData = entity.persistentData;
    if (ePData.hasBeenBuffed){ 
        if(global.TESTING.value) console.log(`Mob: ${entity.type} - Already buffed`);
        return;
    }
    ePData.hasBeenBuffed = true;
    
    const scalingHeight = Math.max(-Math.floor(entity.y / 64), 1);
    const healthScale = 1.0 * scalingHeight;

    const attributes = {
        "minecraft:generic.attack_damage":{
            "base": 2,
            "scale": 0.1 * scalingHeight
        },
        "minecraft:generic.attack_knockback":{
            "base": 0,
            "scale": 0.1 * scalingHeight
        },
        "minecraft:generic.armor":{
            "base": 0,
            "scale": 1 * scalingHeight
        },
        "minecraft:generic.armor_toughness":{
            "base": 0,
            "scale": 1 * scalingHeight
        },
        "minecraft:generic.movement_speed":{
            "base": 0.25,
            "scale": 0.01 * scalingHeight
        }
    }
    modifyEntity(event, 64, healthScale, attributes);
});

PlayerEvents.loggedIn(event => {
    const {player} = event
    if(!player.stages.has("attributes_hotfix")){
        player.stages.add("attributes_hotfix");
        const attributes = {
            "minecraft:generic.attack_damage":{
                "base": 2,
            },
            "minecraft:generic.attack_knockback":{
                "base": 0,
            },
            "minecraft:generic.armor":{
                "base": 0,
            },
            "minecraft:generic.armor_toughness":{
                "base": 0,
            },
            "minecraft:generic.movement_speed":{
                "base": 0.1,
            },
            "minecraft:generic.max_health":{
                "base": 20,
            }
        }
        for(const [attribute, values] of Object.entries(attributes)){
            if(player.getAttributes().hasAttribute(attribute)){
                player.getAttributes().getInstance(attribute).setBaseValue(values.base);
            }
        }

    }
})
function modifyEntity(event, radius, healthScale, attributes) {
    const { entity, level } = event;
    const { x, y, z } = entity;

    // Define area bounding box and count players in radius
    const aabb = AABB.of(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
    const totalPlayers = level.getEntitiesWithin(aabb).filter(e => e.isPlayer()).length;

    // Adjust health based on the number of nearby players
    const baseHealth = entity.getMaxHealth();
    const newHealth = baseHealth * (1 + totalPlayers * healthScale);
    entity.setMaxHealth(newHealth);
    entity.setHealth(newHealth);

    let attributelist = entity.getAttributes();
    for(const [attribute, values] of Object.entries(attributes)){
        let baseValue = values.base;
        if(attributelist.hasAttribute(attribute)){
            baseValue = attributelist.getValue(attribute);
            try{
                entity.getAttributes().getInstance(attribute).setBaseValue(baseValue + values.scale * totalPlayers);
            } catch (e) {
                if(global.TESTING.value) console.log(`Error setting ${attribute} to ${baseValue + values.scale * totalPlayers}`);
            }
            if(global.TESTING.value)  console.log(`Mob: ${entity.type} - Setting ${attribute} to ${entity.getAttributes().getInstance(attribute).getBaseValue()}`);
        }

    }


}
