// priority: 990

ServerEvents.recipes((event) => {
  event.custom({
    "type": "advanced_ae:reaction",
    "input_energy": 5000000,
    "input_fluid": {
      "amount": 500,
      "ingredient": {
        "fluid": "modern_industrialization:cryofluid"
      }
    },
    "input_items": [
      {
        "ingredient": {
          "item": "advanced_ae:quantum_core"
        }
      },
      {
        "amount": 4,
        "ingredient": {
          "item": "modern_industrialization:ultradense_metal_ball"
        }
      },
      {
        "amount": 4,
        "ingredient": {
          "item": "ae2:singularity"
        }
      }
    ],
    "output": {
      "#": 1,
      "#t": "ae2:i",
      "id": "ftbevolution:ultimate_singularity"
    }
  }).id("ftbevolution:ultimate_singularity");

  event.custom({
    "type": "advanced_ae:reaction",
    "input_energy": 5000000,
    "input_fluid": {
      "amount": 10000,
      "ingredient": {
        "fluid": "mekanismgenerators:fusion_fuel"
      }
    },
    "input_items": [
      {
        "amount": 2,
        "ingredient": {
          "item": "mekanism:pellet_antimatter"
        }
      },
      {
        "amount": 1,
        "ingredient": {
          "item": "mekanism:qio_drive_supermassive"
        }
      },
      {
        "amount": 8,
        "ingredient": {
          "item": "mekanism:ultimate_induction_provider"
        }
      }
    ],
    "output": {
      "#": 1,
      "#t": "ae2:i",
      "id": "ftbevolution:mekanized_super_computer"
    }
  }).id("ftb:mekanized_super_computer");

  event.custom({
    "type": "advanced_ae:reaction",
    "input_energy": 5000000,
    "input_fluid": {
      "amount": 10000,
      "ingredient": {
        "fluid": "eternal_starlight:ether"
      }
    },
    "input_items": [
      {
        "amount": 4,
        "ingredient": {
          "item": "fargostalismans:abominable_energy"
        }
      },
      {
        "amount": 1,
        "ingredient": {
          "item": "fargostalismans:ancient_wings_elytra"
        }
      },
      {
        "amount": 8,
        "ingredient": {
          "item": "nautec:prismarine_crystal_shard"
        }
      }
    ],
    "output": {
      "#": 1,
      "#t": "ae2:i",
      "id": "ftbevolution:realized_transcendence"
    }
  }).id("ftbevolution:realized_transcendence");

  event.custom({
    "type": "advanced_ae:reaction",
    "input_energy": 5000000,
    "input_fluid": {
      "amount": 4000,
      "ingredient": {
        "fluid": "nautec:eas"
      }
    },
    "input_items": [
      {
        "amount": 16,
        "ingredient": {
          "item": "immersiveengineering:component_electronic_adv"
        }
      },
      {
        "amount": 16,
        "ingredient": {
          "item": "pneumaticcraft:printed_circuit_board"
        }
      },
      {
        "amount": 64,
        "ingredient": {
          "item": "pneumaticcraft:compressed_iron_block"
        }
      }
    ],
    "output": {
      "#": 1,
      "#t": "ae2:i",
      "id": "ftbevolution:infinitely_compressed_circuit_board"
    }
  }).id("ftbevolution:infinitely_compressed_circuit_board");

  event.custom({
    "type": "advanced_ae:reaction",
    "input_energy": 2500000,
    "input_fluid": {
      "amount": 10000,
      "ingredient": {
        "fluid": "immersiveengineering:high_power_biodiesel"
      }
    },
    "input_items": [
      {
        "amount": 5,
        "ingredient": {
          "item": "mekanism:reprocessed_fissile_fragment"
        }
      },
      {
        "amount": 4,
        "ingredient": {
          "item": "powah:ender_gate_nitro"
        }
      },
      {
        "amount": 1,
        "ingredient": {
          "item": "modern_industrialization:he_uranium_fuel_rod"
        }
      }
    ],
    "output": {
      "#": 1,
      "#t": "ae2:i",
      "id": "ftbevolution:supercritical_mass"
    }
  }).id("ftbevolution:supercritical_mass");

  //Fixing ExtendedAE's Assembler Matrix Pattern Core
  event.custom({
    "type": "extendedae:crystal_assembler",
    "input_items": [
      {
        "ingredient": {
          "item": "extendedae:assembler_matrix_wall"
        }
      },
      {
        "ingredient": {
          "item": "extendedae:ex_pattern_provider"
        }
      },
      {
        "amount": 6,
        "ingredient": {
          "item": "ae2:blue_lumen_paint_ball"
        }
      },
      {
        "ingredient": {
          "item": "ae2:engineering_processor"
        }
      }
    ],
    "output": {
      "count": 1,
      "id": "extendedae:assembler_matrix_pattern"
    }
  }).id("ftbevolution:assembler/assembler_matrix_pattern");

  //Silicon from Quartz should accept any Type of Quartz

  let smelting_silicon_ids = [
    "ae2:blasting/silicon_from_certus_quartz_dust",
    "ae2:smelting/silicon_from_certus_quartz_dust"
  ]

  smelting_silicon_ids.forEach(recipe => {
    event.replaceInput(
      { id: recipe },
      'ae2:certus_quartz_dust',
      '#ftbevolution:quartz_dust'
    );
  });

  //Also Adding to the Alloy Smelter Manually
  event.custom({
    type: "enderio:alloy_smelting",
    energy: 1500,
    experience: 0.3,
    inputs: [
      {
        count: 1,
        tag: 'ftbevolution:quartz_dust',
      }
    ],
    output: {
      count: 1,
      id: "ae2:silicon",
    },
  }).id("ftbevolution:alloy_smelting/silicon_from_quartz_dust");

  //Buffing Not So Mysterious Block Recipe
  event.shaped(
    Item.of('ae2:not_so_mysterious_cube', 24),
    [
      'SPS',
      'PCP',
      'SPS'
    ],
    {
      C: 'ae2:controller',
      P: '#ae2:inscriber_presses',
      S:'ae2:smooth_sky_stone_block'
    }
  ).id("ftbevolution:ae2/shaped/not_so_mysterious_cube");
  
});
