// priority: 985

ServerEvents.recipes((event) => {

    //Fixing Conduit Binder Smelting
    event.custom({
        "type": "enderio:alloy_smelting",
        "energy": 1600,
        "experience": 0.3,
        "inputs": [
          {
            "count": 1,
            "item": 'enderio:conduit_binder_composite'
          }
        ],
        "output": {
          "count": 2,
          "id": 'enderio:conduit_binder'
        }
    })

    //Adding a Recipe for the Powered Spawner
    event.shaped("enderio:powered_spawner", ["SKS", "SCS", "VZV"], {
      C: "enderio:ensouled_chassis",
      S: "#c:ingots/soularium",
      Z: "enderio:z_logic_controller",
      V: "#c:gems/vibrant_crystal",
      K: "#c:skulls"
    }).id("ftbevolution:enderio/powered_spawner");

    //Tagging Enderman Head in Recipes.
    event.replaceInput(
      { id: "enderio:aversion_obelisk" },
      "enderio:enderman_head",
      "#ftb:enderman_head"
    );

    //Adding FTB Materials Raw Ores to the Sag-Mill
    let enderio_raw_material_sag_milling = [
      ["c:raw_materials/aluminum", "ftbmaterials:aluminum_dust"],
      ["c:raw_materials/lead", "ftbmaterials:lead_dust"],
      ["c:raw_materials/nickel", "ftbmaterials:nickel_dust"],
      ["c:raw_materials/osmium", "ftbmaterials:osmium_dust"],
      ["c:raw_materials/silver", "ftbmaterials:silver_dust"],
      ["c:raw_materials/tin", "ftbmaterials:tin_dust"],
      ["c:raw_materials/uranium", "ftbmaterials:uranium_dust"],
      ["c:raw_materials/antimony", "ftbmaterials:antimony_dust"],
      ["c:raw_materials/iridium", "ftbmaterials:iridium_dust"],
      ["c:raw_materials/tungsten", "ftbmaterials:tungsten_dust"],
      ["c:raw_materials/titanium", "ftbmaterials:titanium_dust"],
      ["c:raw_materials/platinum", "ftbmaterials:platinum_dust"]
    ];

    enderio_raw_material_sag_milling.forEach(recipe => {
       event.custom({
          "type": "enderio:sag_milling",
          "energy": 2400,
          "input": {
           "tag": recipe[0]
          },
          "outputs": [
           {
            "item": {
             "count": 1,
             "id": recipe[1]
            }
           },
           {
            "chance": 0.25,
            "item": {
             "count": 1,
             "id": recipe[1]
            }
           }
          ]
        }).id("ftb:enderio/sagmilling/ftbmaterials/" + recipe[0].split(":")[1]);
    });

    //Adding a Electrum Alloying Recipe.
    event.custom({
      "type": "enderio:alloy_smelting",
      "energy": 1600,
      "experience": 0.5,
      "inputs": [
        {
          "count": 1,
          "tag": 'c:ingots/silver'
        },
        {
          "count": 1,
          "tag": 'c:ingots/gold'
        }
      ],
      "output": {
        "count": 2,
        "id": 'ftbmaterials:electrum_ingot'
      }
  }).id("ftb:enderio/alloy_smelting/electrum")

    event.custom({
      "type": "enderio:alloy_smelting",
      "energy": 1600,
      "experience": 0.5,
      "inputs": [
        {
          "count": 1,
          "tag": 'c:dusts/redstone'
        },
        {
          "count": 1,
          "tag": 'c:ingots/gold'
        }
      ],
      "output": {
        "count": 1,
        "id": 'ftbmaterials:electrum_ingot'
      }
  }).id("ftb:enderio/alloy_smelting/electrum_weird")
    
  //Fixing Enderios Unification
  event.replaceInput({ id: "enderio:enderios" }, "enderio:powdered_ender_pearl","#c:dusts/ender_pearl");

});