// priority: 983

ServerEvents.recipes((event) => {

    let big_screens = [['ftbquests:screen_3', 3], ['ftbquests:screen_5', 5], ['ftbquests:screen_7', 7]];
    let t1_s = 'ftbquests:screen_1';

    //Tier 1 Screen
    event.shaped(t1_s,
        [
            "GCI", 
            "GFI", 
            "GTI"
        ],
        {
          F: 'industrialforegoing:machine_frame_pity',
          C: '#c:chests/wooden',
          T: '#ftbevolution:tanks',
          I: '#c:plates/iron',
          G: '#c:glass_panes'
        }
      ).id("ftbevolution:task_screen_1");
    
    big_screens.forEach(screen => {
        //Shapeless Revert to 1x Screen
        event.shapeless(Item.of(t1_s, screen[1]), [screen[0]])
        
        if (screen[1] == 3) {
            event.shapeless(Item.of('ftbquests:screen_3', 1), [t1_s, t1_s, t1_s]).id("ftbevolution:task_screen_3");
        } if (screen[1] == 5) {
            event.shapeless(Item.of('ftbquests:screen_5', 1), [t1_s, t1_s, t1_s, t1_s, t1_s]).id("ftbevolution:task_screen_5");
        } else {
            event.shapeless(Item.of('ftbquests:screen_7', 1), [t1_s, t1_s, t1_s, t1_s, t1_s, t1_s, t1_s]).id("ftbevolution:task_screen_7");
        }
    });


    //Adding Smelt Recipes for Zinc Dust
    event.smelting("ftbmaterials:zinc_ingot", "ftbmaterials:zinc_dust")
    event.blasting("ftbmaterials:zinc_ingot", "ftbmaterials:zinc_dust")

    //Adjusting Plate Recipes Accordinly ==========================================================

    let plates_that_need_adjusting = [
      {
        input: "c:ingots/netherite",
        output: "ftbmaterials:netherite_plate",
        shapeless: true,
        mi: true,
        ie: true,
        create: true
      },
      {
        input: "c:ingots/uranium",
        output: "ftbmaterials:uranium_plate",
        shapeless: true,
        mi: true,
        ie: true,
        create: false
      },
      {
        input: "c:ingots/xy_aluminum",
        output: "immersiveengineering:plate_aluminum",
        shapeless: true,
        mi: true,
        ie: true,
        create: true
      },
      {
        input: "c:ingots/aluminum",
        output: "ftbmaterials:aluminum_plate",
        shapeless: true,
        mi: false,
        ie: false,
        create: false
      },
    ];

    plates_that_need_adjusting.forEach(plate => {
        let input_name = plate.input.split(":")[1]
        let output_name = plate.output.split(":")[1]

        if (plate.shapeless) {
          event.shapeless(Item.of(plate.output, 1), ["#" + plate.input, "immersiveengineering:hammer"]).id("ftb:shapeless/hammering/" + input_name);
        } else {
          return
        }
        
        if (plate.mi) {
          event.custom({
              "type": "modern_industrialization:compressor",
              "duration": 200,
              "eu": 2,
              "item_inputs": [
                {
                  "amount": 1,
                  "tag": plate.input
                }
              ],
              "item_outputs": [
                {
                  "amount": 1,
                  "item": plate.output
                }
              ]
          }).id("ftb:modern_industrialization/compressing/" + input_name + "_to_" + output_name);
        } else {
          return
        }
        
        if (plate.ie) {
          event.custom({
              "type": "immersiveengineering:metal_press",
              "energy": 2400,
              "input": {
                "tag": plate.input
              },
              "mold": "immersiveengineering:mold_plate",
              "result": {
                "item": plate.output
              }
            }).id("ftb:immersive_engineering/metal_press/" + input_name + "_to_" + output_name);
        } else {
          return
        }

        if (plate.create) {
          event.custom({
            "type": "create:pressing",
            "ingredients": [
              {
                "tag": plate.input
              }
            ],
            "results": [
              {
                "id": plate.output
              }
            ]
          }).id("ftb:create/pressing/" + input_name + "_to_" + output_name);
        } else {
          return
        }

    });

    //Adjusting Raw Block Recipes
    
    let raw_blocks_to_raw = [
      ["#c:storage_blocks/raw_uranium", "ftbmaterials:uranium_raw_ore"],
      ["#c:storage_blocks/raw_iridium", "ftbmaterials:iridium_raw_ore"],
      ["#c:storage_blocks/raw_platinum", "ftbmaterials:platinum_raw_ore"]
    ];

    raw_blocks_to_raw.forEach(raw_block => {
      let input_name = raw_block[0].split(":")[1]
      event.shapeless(Item.of(raw_block[1], 9), [raw_block[0]]).id("ftb:shapeless/decompressing/" + input_name);
    });

    //Making Copper Nuggets Compactable with Drawers
    event.custom({
      type: "functionalstorage:custom_compacting",
      higher_input: {
        count: 1,
        id: "minecraft:copper_ingot"
      },
      lower_input: {
        count: 9,
        id: "ftbmaterials:copper_nugget"
      },
    });

    //Fixing Charcoal Dust Unification.
    
    let charcoal_dust_recipes = [
      "mekanism:crushing/charcoal_dust",
      "mekanism:enriching/charcoal_dust",
      "mekanism:reaction/wood_gasification/logs",
      "mekanism:reaction/wood_gasification/planks"
    ];

    charcoal_dust_recipes.forEach(id => {
        event.replaceOutput(
          { id: `${id}` },
          "mekanism:dust_charcoal",
          "ftbmaterials:charcoal_dust",
        );
    });    

    //Fixing Sulfur Recipes =======================================================================

    let sulfur_dust_recipes = [
      "mekanism:injecting/gunpowder_to_sulfur",
      "modern_industrialization:materials/sulfur/craft/dust_from_block",
      "modern_industrialization:materials/sulfur/craft/dust_from_tiny_dust",
      "mekanism:reaction/coal_gasification/blocks_coals",
      "mekanism:reaction/coal_gasification/dusts_coals",
      "mekanism:reaction/coal_gasification/coals",
      "modern_industrialization:vanilla_recipes/centrifuge/lava",
      "modern_industrialization:materials/electrolyzer/sulfuric_acid",
      "modern_industrialization:materials/sulfur/packer/dust",
      "modern_industrialization:materials/sulfur/unpacker/dust",
    ];

    sulfur_dust_recipes.forEach(id => {
      event.replaceOutput(
        { id: `${id}` },
        "mekanism:dust_sulfur",
        "ftbmaterials:sulfur_dust",
      );
  });  

    event.replaceInput(
      { id: "modern_industrialization:materials/sulfur/craft/block_from_dust" },
      "mekanism:dust_sulfur",
      "ftbmaterials:sulfur_dust",
    );
    
    //Fixing Tin Block Recipes.
    event.shapeless(Item.of("ftbmaterials:tin_ingot", 9), ["#c:storage_blocks/tin"]).id("ftb:shapeless/ingots_from_blocks/tin");
    event.shaped("ftbmaterials:tin_block",
      [
        "III", 
        "III", 
        "III"
      ],
      {
        I: "#c:ingots/tin",
      }
    ).id("ftb:shaped/blocks_from_ingots/tin");
    
    //Fixing Raw Silver Block Recipes.
    event.shaped("ftbmaterials:silver_raw_block",
      [
          "III", 
          "III", 
          "III"
      ],
      {
        I: "#c:raw_materials/silver",
      }
    ).id("ftb:shaped/blocks_from_raw/silver");

});