// priority: 980

let aluminum_recipes = [
    ["immersiveengineering:crafting/tesla_coil", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/sheetmetal_aluminum", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/capacitor_hv", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/armor_faraday_helmet", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/armor_faraday_chestplate", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/armor_faraday_leggings", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/armor_faraday_boots", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/armor_faraday_boots", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/toolbox", '#c:plates/aluminum', '#c:plates/xy_aluminum'],
    ["immersiveengineering:crafting/toolupgrade_powerpack_tesla", '#c:plates/aluminum', '#c:plates/xy_aluminum'],

    ["immersiveengineering:crafting/connector_hv_relay", '#c:ingots/aluminum', '#c:ingots/xy_aluminum'],
    ["immersiveengineering:crafting/connector_hv", '#c:ingots/aluminum', '#c:ingots/xy_aluminum']

]

ServerEvents.recipes((event) => {
    aluminum_recipes.forEach(element => {
        event.replaceInput(
            { id: element[0] },
            element[1],
            element[2]
        )
    });

    //IE Aluminum Conversion
    event.custom({
        "type": "immersiveengineering:arc_furnace",
        "additives": [],
        "energy": 25600,
        "input": {
            "item": "xycraft_world:aluminum_ingot"
        },
        "results": [
            { 
            "item": "ftbmaterials:aluminum_ingot"
            }
        ],
        "time": 100
    }).id("ftb:arc_aluminum_conversion");

    event.custom({
        "type": "immersiveengineering:arc_furnace",
        "additives": [],
        "energy": 25600,
        "input": {
            "item": "ftbevolution:xy_aluminum_dust"
        },
        "results": [
            { 
            "item": "ftbmaterials:aluminum_ingot"
            }
        ],
        "time": 100
    }).id("ftb:arc_aluminum__dust_conversion")

    //Adding a Convertion Recipe for Aluminum
    event.shapeless(
        Item.of("ftbmaterials:aluminum_ingot", 1),
       [
        "immersiveengineering:ingot_aluminum"
       ]
   ).id("ftb:shapeless/aluminum_convertion");
   
   //Adjusting Raw Titanium Arc Furnace Recipe to produce Hot Ingots.
   event.custom({
    "type": "immersiveengineering:arc_furnace",
    "additives": [],
    "energy": 25600,
    "input": {
        "basePredicate": {
          "tag": "c:dusts/titanium"
        },
        "count": 1
    },
    "results": [
      {
        "item": 'modern_industrialization:titanium_hot_ingot'
      }
    ],
    "time": 100
  }).id("ftb:immersiveengineering/arc_furnace/titanium_dust");

});
