// priority: 975

ServerEvents.recipes((event) => {
  let materials_replacements = [
    //Raw Ores
    ["modern_industrialization:raw_silver", "occultism:raw_silver"],
    ["modern_industrialization:raw_silver_block", "occultism:raw_silver_block"],
    ["modern_industrialization:raw_uranium", "mekanism:raw_uranium"],
    [
      "modern_industrialization:raw_uranium_block",
      "mekanism:block_raw_uranium",
    ],
    ["modern_industrialization:raw_lead", "mekanism:raw_lead"],
    ["modern_industrialization:raw_lead_block", "mekanism:block_raw_lead"],
    ["modern_industrialization:raw_tin", "mekanism:raw_tin"],
    ["modern_industrialization:raw_tin_block", "mekanism:block_raw_tin"],
    ["modern_industrialization:raw_platinum", "ftbmaterials:platinum_raw_ore"],


    //Blocks
    ["modern_industrialization:steel_block", "mekanism:block_steel"],
    ["modern_industrialization:bronze_block", "mekanism:block_bronze"],
    ["modern_industrialization:tin_block", "mekanism:block_tin"],
    ["modern_industrialization:lead_block", "mekanism:block_lead"],
    ["modern_industrialization:uranium_block", "mekanism:block_uranium"],
    ["modern_industrialization:silver_block", "occultism:silver_block"],

    //Ingots
    ["modern_industrialization:steel_ingot", "mekanism:ingot_steel"],
    ["modern_industrialization:bronze_ingot", "mekanism:ingot_bronze"],
    ["modern_industrialization:tin_ingot", "mekanism:ingot_tin"],
    ["modern_industrialization:lead_ingot", "mekanism:ingot_lead"],
    ["modern_industrialization:uranium_ingot", "mekanism:ingot_uranium"],
    ["modern_industrialization:silver_ingot", "occultism:silver_ingot"],

    //Nuggets
    ["modern_industrialization:steel_nugget", "mekanism:nugget_steel"],
    ["modern_industrialization:bronze_nugget", "mekanism:nugget_bronze"],
    ["modern_industrialization:tin_nugget", "mekanism:nugget_tin"],
    ["modern_industrialization:lead_nugget", "mekanism:nugget_lead"],
    ["modern_industrialization:uranium_nugget", "mekanism:nugget_uranium"],
    ["modern_industrialization:silver_nugget", "occultism:silver_nugget"],

    //Dusts
    ["modern_industrialization:lapis_dust", "mekanism:dust_lapis_lazuli"],
    ["modern_industrialization:steel_dust", "mekanism:dust_steel"],
    ["modern_industrialization:bronze_dust", "mekanism:dust_bronze"],
    ["modern_industrialization:tin_dust", "mekanism:dust_tin"],
    ["modern_industrialization:lead_dust", "mekanism:dust_lead"],
    ["modern_industrialization:uranium_dust", "mekanism:dust_uranium"],
    ["modern_industrialization:sulfur_dust", "mekanism:dust_sulfur"],
    ["modern_industrialization:coal_dust", "ftbmaterials:coal_dust"],
    ["modern_industrialization:wood_pulp", "mekanism:sawdust"],
    ["modern_industrialization:quartz_dust", "mekanism:dust_quartz"],
    ["modern_industrialization:emerald_dust", "mekanism:dust_emerald"],
    ["modern_industrialization:diamond_dust", "mekanism:dust_diamond"],
    ["modern_industrialization:iron_dust", "mekanism:dust_iron"],
    ["modern_industrialization:gold_dust", "mekanism:dust_gold"],
    ["modern_industrialization:copper_dust", "mekanism:dust_copper"],
    ["modern_industrialization:silver_dust", "occultism:silver_dust"],
    ["extended_industrialization:netherite_dust", "mekanism:dust_netherite"],
  ];

  materials_replacements.forEach((recipe) => {
    //MI
    event.replaceInput(
      { mod: "modern_industrialization" },
      `${recipe[0]}`,
      `${recipe[1]}`
    );
    event.replaceOutput(
      { mod: "modern_industrialization" },
      `${recipe[0]}`,
      `${recipe[1]}`
    );

    //Extended MI
    event.replaceInput(
      { mod: "extended_industrialization" },
      `${recipe[0]}`,
      `${recipe[1]}`
    );
    event.replaceOutput(
      { mod: "extended_industrialization" },
      `${recipe[0]}`,
      `${recipe[1]}`
    );
  });



  // Heavy Water 10000
  event
    .custom({
      type: "modern_industrialization:centrifuge",
      eu: 2,
      duration: 100,
      fluid_inputs: [
        {
          amount: 10000,
          fluid: "mekanism:heavy_water",
        },
      ],
      fluid_outputs: [
        {
          amount: 10000,
          fluid: "modern_industrialization:heavy_water",
        },
      ],
    })
    .id("ftbevolution:heavy_water_convertion");

  event
    .custom({
      type: "modern_industrialization:mixer",
      eu: 32,
      duration: 80,
      fluid_inputs: [
        {
          fluid: "modern_industrialization:crude_oil",
          amount: 100,
        },
      ],
      item_inputs: [
        {
          item: "actuallyadditions:crystallized_canola_seed",
          amount: 1,
        },
      ],
      fluid_outputs: [
        {
          fluid: "actuallyadditions:crystallized_oil",
          amount: 600,
        },
      ],
    })
    .id("ftbevolution:crystallized_oil");


    event
    .custom({
      type: "extended_industrialization:alloy_smelter",
      eu: 4,
      duration: 200,
      item_inputs: [
        {
          tag: "c:dusts/tin",
          amount: 1,
        },        {
          tag: "c:dusts/copper",
          amount: 3,
        }
      ],
      item_outputs: [
        {
          item: "ftbmaterials:bronze_ingot",
          amount: 4,
        },
      ],
    })
    .id("ftbevolution:bronze_ingot_from_dusts");

    
    event
    .custom({
      type: "extended_industrialization:alloy_smelter",
      eu: 4,
      duration: 200,
      item_inputs: [
        {
          tag: "c:ingots/tin",
          amount: 1,
        },        {
          tag: "c:ingots/copper",
          amount: 3,
        }
      ],
      item_outputs: [
        {
          item: "ftbmaterials:bronze_ingot",
          amount: 4,
        },
      ],
    })
    .id("ftbevolution:bronze_ingot_from_ingots");

    event
    .custom({
      type: "modern_industrialization:mixer",
      eu: 32,
      duration: 40,
      fluid_inputs: [
        {
          fluid: "actuallyadditions:crystallized_oil",
          amount: 100,
        },
      ],
      item_inputs: [
        {
          item: "actuallyadditions:empowered_canola_seed",
          amount: 1,
        },
      ],
      fluid_outputs: [
        {
          fluid: "actuallyadditions:empowered_oil",
          amount: 600,
        },
      ],
    })
    .id("ftbevolution:empowered_oil");

event.custom({
  "type": "modern_industrialization:assembler",
  "duration": 400,
  "eu": 64,
  "fluid_inputs": [
    {
      "amount": 90,
      "fluid": "mffs:fortron_fluid"
    }
  ],  
  "item_inputs": [
    {
      "amount": 4,
      "item": "geneticsresequenced:dna_helix"
    },
    {
      "amount": 4,
      "item": "modern_industrialization:qubit"
    },
    {
      "amount": 16,
      "item": "mekanism:ultimate_control_circuit"
    },
    {
      "amount": 16,
      "item": "megacells:accumulation_processor"
    }
  ],
  "item_outputs": [
    {
      "amount": 1,
      "item": "ftbevolution:bio_neural_circuit"
    }
  ]
}).id("ftb:bio_neural_circuit");

  //Adding PnC Crude Oil to Blast Furnace
  event.custom({  
  "type": "modern_industrialization:blast_furnace",
  "eu": 2,
  "duration": 10,
  "fluid_inputs": [
    {
      "fluid": "pneumaticcraft:oil",
      "amount": 100
    }
  ],
  "fluid_outputs": [
    {
      "fluid": "modern_industrialization:synthetic_oil",
      "amount": 100
    }
  ]}).id("ftb:crude_to_synthetic");

  event.custom({  
    "type": "modern_industrialization:blast_furnace",
    "eu": 2,
    "duration": 10,
    "fluid_inputs": [
      {
        "fluid": "modern_industrialization:crude_oil",
        "amount": 100
      }
    ],
    "fluid_outputs": [
      {
        "fluid": "modern_industrialization:synthetic_oil",
        "amount": 100
      }
    ]}).id("ftbevolution:crude_to_synthetic_1");

  //Fixing Nuclear Casing Assembler Recipe
  event.custom({  
    "type": "modern_industrialization:assembler",
    "duration": 200,
    "eu": 8,
    "item_inputs": [
      {
        "amount": 8,
        "tag": "c:plates/nuclear_alloy"
      },
      {
        "amount": 1,
        "item": "modern_industrialization:turbo_machine_hull"
      }
    ],
    "item_outputs": [
      {
        "amount": 4,
        "item": "modern_industrialization:nuclear_casing"
      }
    ]}).id("ftb:assembler/electric_age/casing/nuclear_casing");

    //Fixing Silicon Block Unpacking to keep the 2 Silicons Separated
    event.replaceInput(
      { id: "modern_industrialization:materials/silicon/unpacker/ingot" },
      'extendedae:silicon_block',
      'modern_industrialization:silicon_block'
    )
    
    //Fixing Copper Dust Recipes Outputing the wrong type of Copper Dust
    let mi_copper_dust_recipes = [
      "modern_industrialization:materials/copper/macerator/curved_plate",
      "modern_industrialization:materials/copper/macerator/double_ingot",
      "modern_industrialization:materials/copper/macerator/gear",
      "modern_industrialization:materials/copper/macerator/ingot",
      "modern_industrialization:materials/copper/macerator/plate",
      "modern_industrialization:materials/copper/macerator/raw_metal",
      "modern_industrialization:materials/copper/macerator/rotor",
      "modern_industrialization:materials/copper/packer/dust",
      "modern_industrialization:materials/copper/forge_hammer/ingot_to_dust",
      "modern_industrialization:materials/copper/forge_hammer/raw_metal_to_dust_with_tool",
      "modern_industrialization:materials/forge_hammer/copper_ore_to_dust_with_tool"
    ];
    
    mi_copper_dust_recipes.forEach(recipe_id => {
      event.replaceOutput(
        { id: recipe_id },
        'mekanism:dust_copper',
        'ftbmaterials:copper_dust'
      );
    });
    
    //Fixing Modern Industrialization's Uranium Recipes. ==========================================

    let mi_uranium_recipes = [
      "modern_industrialization:materials/uranium/unpacker/ingot",
      "modern_industrialization:materials/uranium/packer/ingot",
      "modern_industrialization:materials/uranium/packer/block",
      "modern_industrialization:materials/uranium/craft/ingot_from_block"
    ];
    
    mi_uranium_recipes.forEach(recipe_id => {
      event.replaceOutput(
        { id: recipe_id },
        'mekanism:ingot_uranium',
        'ftbmaterials:uranium_ingot'
      );
    });

    event.replaceOutput(
      { id: "modern_industrialization:materials/uranium/unpacker/nugget" },
      'mekanism:nugget_uranium',
      'ftbmaterials:uranium_nugget'
    );

    event.replaceInput(
      { id: "modern_industrialization:materials/uranium/craft/ingot_from_block" },
      'mekanism:block_uranium',
      'ftbmaterials:uranium_block'
    );

    event.replaceInput(
      { id: "modern_industrialization:materials/uranium/craft/block_from_ingot" },
      'mekanism:ingot_uranium',
      'ftbmaterials:uranium_ingot'
    );

    event.replaceOutput(
      { id: "modern_industrialization:materials/uranium/craft/block_from_ingot" },
      'mekanism:block_uranium',
      'ftbmaterials:uranium_block'
    );

    event.replaceOutput(
      { id: "modern_industrialization:materials/uranium/packer/block" },
      'mekanism:block_uranium',
      'ftbmaterials:uranium_block'
    );
    
    // ============================================================================================
    
    //Fixing Modern Industrialization's Tin Recipes. ==============================================

    event.replaceOutput(
      { id: "modern_industrialization:materials/tin/packer/raw_metal_block" },
       'mekanism:block_raw_tin',
       'ftbmaterials:tin_raw_block'
    );
    
    let mi_raw_tin_recipes = [
      "modern_industrialization:materials/tin/forge_hammer/ore_to_raw_metal",
      "modern_industrialization:materials/tin/forge_hammer/ore_to_raw_metal_with_tool",
      "modern_industrialization:materials/tin/unpacker/raw_metal"
    ];

    mi_raw_tin_recipes.forEach(id => {
      event.replaceOutput(
        { id: id },
         'mekanism:raw_tin',
         'ftbmaterials:tin_raw_ore'
      );
    });

    // ============================================================================================

    //Fixing 2 Specific MI Recipes that still use its Steel Plates.
    event.replaceInput(
      { id: "extended_industrialization:casing/craft/steel_plated_bricks" },
       "modern_industrialization:steel_plate",
       "#c:plates/steel"
    );
    event.replaceInput(
      { id: "extended_industrialization:casing/assembler/steel_plated_bricks" },
       "modern_industrialization:steel_plate",
       "#c:plates/steel"
    );

    //Adding a way to get Silicon from MI from Silicon Essence.
    event.custom({
      "type": "modern_industrialization:blast_furnace",
      "eu": 128,
      "duration": 200,
      "item_inputs":[
        {
        "item": "mysticalagriculture:silicon_essence",
        "amount": 3
        },
        {
        "tag": "c:dusts/coke",
        "amount": 1
        }
      ],
      "item_outputs": {
        "item": "modern_industrialization:silicon_dust",
        "amount": 8
      }
    }).id("ftb:modern_industrialization/materials/blast_furnace/essence_silicium_coke")

    event.custom({
      "type": "modern_industrialization:blast_furnace",
      "eu": 128,
      "duration": 200,
      "item_inputs":[
        {
        "item": "mysticalagriculture:silicon_essence",
        "amount": 3
        },
        {
        "tag": "c:dusts/carbon",
        "amount": 1
        }
      ],
      "item_outputs": {
        "item": "modern_industrialization:silicon_dust",
        "amount": 12
      }
    }).id("ftb:modern_industrialization/materials/blast_furnace/essence_silicium_carbon");

    //Xyluminum Conversion using a Blast Furnace.
    event.custom({
      "type": "modern_industrialization:blast_furnace",
      "eu": 32,
      "duration": 200,
      "item_inputs":[
        {
        "item": "xycraft_world:aluminum_ingot",
        "amount": 1
        }
      ],
      "item_outputs": {
        "item": "ftbmaterials:aluminum_ingot",
        "amount": 1
      }
    }).id("ftb:modern_industrialization/materials/blast_furnace/aluminum_from_xyluminum");

    //Fixing Copper Plate Unification
    let copper_plate_ids = [
      "immersiveengineering:crafting/plate_copper_hammering",
      "modern_industrialization:materials/copper/compressor/double_ingot",
      "modern_industrialization:materials/copper/compressor/main",
      "modern_industrialization:materials/copper/forge_hammer/double_ingot_to_plate",
      "modern_industrialization:materials/copper/forge_hammer/double_ingot_to_plate_with_tool",
      "modern_industrialization:materials/copper/forge_hammer/ingot_to_plate",
      "modern_industrialization:materials/copper/forge_hammer/ingot_to_plate_with_tool"
    ];

    copper_plate_ids.forEach(id => {
      event.replaceOutput(
        { id: id },
         "modern_industrialization:copper_plate",
         "ftbmaterials:copper_plate"
      );
    });

    //Fixing Copper Nugget Unification
    event.shapeless(Item.of("ftbmaterials:copper_nugget", 1), ["modern_industrialization:copper_nugget"]).id("ftb:shapeless/copper_nugget_convertion");
    let copper_nugget_ids = [
      "modern_industrialization:materials/copper/smelting/tiny_dust_to_nugget_blasting",
      "modern_industrialization:materials/copper/smelting/tiny_dust_to_nugget_smelting",
      "modern_industrialization:vanilla_recipes/centrifuge/lava",
      "modern_industrialization:materials/copper/unpacker/nugget"
    ];

    copper_nugget_ids.forEach(id => {
      event.replaceOutput(
        { id: id },
         "modern_industrialization:copper_nugget",
         "ftbmaterials:copper_nugget"
      );
    });

    //Fixing Uranium Dust Unification
    event.replaceInput({ id: "modern_industrialization:materials/uranium/craft/tiny_dust_from_dust" }, "mekanism:dust_uranium", "ftbmaterials:uranium_dust");
    let uranium_dust_ids = [
      "modern_industrialization:materials/uranium/craft/dust_from_tiny_dust",
      "modern_industrialization:materials/uranium/packer/dust"
    ];

    uranium_dust_ids.forEach(id => {
      event.replaceOutput(
        { id: id },
         "mekanism:dust_uranium",
         "ftbmaterials:uranium_dust"
      );
    });

    //Making the Brick Macerating Recipe also accept any Brick Ingot.
    let brick_macerating_recipes = [
      "modern_industrialization:materials/brick/macerator/ingot",
      "modern_industrialization:materials/forge_hammer/brick_dust_with_tool"
    ];

    brick_macerating_recipes.forEach(recipe => {
      event.replaceInput(
        { id: recipe },
         "minecraft:brick",
         "#c:ingots/brick"
      );
    });
    
    //Fixing Unpacking Recipe of Glowstone
    event.custom({
      "type": "modern_industrialization:unpacker",
      "duration": 100,
      "eu": 2,
      "item_inputs": [
        {
          "amount": 1,
          "item": "minecraft:glowstone"
        }
      ],
      "item_outputs": [
        {
          "amount": 4,
          "item": "minecraft:glowstone_dust"
        }
      ]
    }).id("ftb:modern_industrialization/unpacker/glowstone_dust");
    
    //Fixing Extended Industrialization's Electrum Recipes.
    event.replaceInput({ id: "extended_industrialization:materials/electrum/alloy_smelter/block" },"occultism:silver_block","#c:storage_blocks/silver");
    event.replaceOutput({ id: "extended_industrialization:materials/electrum/alloy_smelter/nugget" },"modern_industrialization:electrum_ingot","ftbmaterials:electrum_ingot");
    
    //Fixing Extended Industrialization's Bronze Recipes.
    event.replaceOutput({ id: "extended_industrialization:materials/bronze/alloy_smelter/nugget" },"mekanism:ingot_bronze","ftbmaterials:bronze_ingot");
    
    //Fixing Extended Industrialization's Invar Recipes.
    event.replaceOutput({ id: "extended_industrialization:materials/invar/alloy_smelter/nugget" },"modern_industrialization:invar_ingot","ftbmaterials:invar_ingot");
    
    //Fixing MI's Unpacking Recipes.
    event.replaceOutput({ id: "modern_industrialization:materials/iridium/unpacker/raw_metal" },"modern_industrialization:raw_iridium","ftbmaterials:iridium_raw_ore");
    event.replaceOutput({ id: "modern_industrialization:materials/lead/unpacker/raw_metal" },"mekanism:raw_lead","ftbmaterials:lead_raw_ore");
    event.replaceOutput({ id: "modern_industrialization:materials/nickel/unpacker/raw_metal" },"modern_industrialization:raw_nickel","ftbmaterials:nickel_raw_ore");
    event.replaceOutput({ id: "modern_industrialization:materials/uranium/unpacker/raw_metal" },"mekanism:raw_uranium","ftbmaterials:uranium_raw_ore");
    
    //Fixing MI's Packing Recipes.
    event.replaceOutput({ id: "modern_industrialization:materials/uranium/packer/raw_metal_block" },"mekanism:block_raw_uranium","ftbmaterials:uranium_raw_block");
    event.replaceOutput({ id: "modern_industrialization:materials/lead/packer/raw_metal_block" },"mekanism:block_raw_lead","ftbmaterials:lead_raw_block");
    
    //Fixing Unification of Extended Industrialization's Silver Recipes.
    event.replaceInput({ id: "modern_industrialization:materials/silver/unpacker/ingot" }, "occultism:silver_block","#c:storage_blocks/silver");
    event.replaceInput({ id: "extended_industrialization:materials/electrum/alloy_smelter/nugget" }, "occultism:silver_nugget","#c:nuggets/silver");
    event.replaceInput({ id: "modern_industrialization:materials/silver/macerator/nugget" }, "occultism:silver_nugget","#c:nuggets/silver");
    event.replaceInput({ id: "modern_industrialization:materials/silver/packer/ingot" }, "occultism:silver_nugget","#c:nuggets/silver");
    event.replaceOutput({ id: "extended_industrialization:materials/silver/macerator/curved_plate" },"occultism:silver_dust","ftbmaterials:silver_dust");
    
    //Fixing Tesla Coil Recipe Unification
    event.replaceInput({ id: "extended_industrialization:machines/lethal_tesla_coil/craft" }, "modern_industrialization:tungsten_plate","#c:plates/tungsten");
    event.replaceInput({ id: "extended_industrialization:machines/lethal_tesla_coil/assembler" }, "modern_industrialization:tungsten_plate","#c:plates/tungsten");
    
    //Fixing Steel Anvil Recipe Unification
    event.replaceInput({ id: "modern_industrialization:assembler_generated/vanilla_recipes/steel_anvil" }, "mekanism:block_steel","#c:storage_blocks/steel");
    event.replaceInput({ id: "modern_industrialization:assembler_generated/vanilla_recipes/steel_anvil" }, "mekanism:ingot_steel","#c:ingots/steel");

});
