// priority: 970

ServerEvents.recipes((event) => {
	//Unification Fixes related to Oritech's BioSteel =============================================

	//Readding Default Steel Block Recipes so it avoids BioSteel

	let replacing_steel_block_tag = [
		"ftbmaterials:steel_ingot_from_steel_block",
		"modern_industrialization:materials/steel/unpacker/ingot"
	];

	replacing_steel_block_tag.forEach((id) => {
		event.replaceInput(
			{ id: id },
			"#c:storage_blocks/steel",
			"ftbmaterials:steel_block"
		);
	});

	//Readding Default Steel Ingot Recipes so it avoids BioSteel

	let replacing_steel_ingot_tag = [
		"ftbmaterials:steel_block",
		"ftb:eio_crushing_c_ingots/steel",
		"mekanism:processing/steel/ingot_to_dust",
		"modern_industrialization:materials/steel/macerator/ingot",
		"modern_industrialization:materials/steel/unpacker/nugget",
		"occultism:crushing/steel_dust_from_ingot",
		"modern_industrialization:materials/steel/forge_hammer/ingot_to_dust"
	];

	replacing_steel_ingot_tag.forEach((id) => {
		event.replaceInput(
			{ id: id },
			"#c:ingots/steel",
			"ftbmaterials:steel_ingot"
		);
	});

	//Manually Readding Recipes that couldn't be replaced
	event.custom({
		type: "immersiveengineering:crusher",
		energy: 3000,
		input: {
			item: "ftbmaterials:steel_ingot"
		},
		result: {
			tag: "c:dusts/steel"
		}
	});
	event.custom({
		type: "oritech:grinder",
		fluidInput: {
			amount: 0,
			fluid: "minecraft:empty"
		},
		fluidOutput: {
			amount: 0,
			fluid: "minecraft:empty"
		},
		ingredients: [
			{
				item: "ftbmaterials:steel_ingot"
			}
		],
		results: [
			{
				count: 1,
				id: "ftbmaterials:steel_dust"
			}
		],
		time: 200
	});
	event.custom({
		type: "oritech:pulverizer",
		fluidInput: {
			amount: 0,
			fluid: "minecraft:empty"
		},
		fluidOutput: {
			amount: 0,
			fluid: "minecraft:empty"
		},
		ingredients: [
			{
				item: "ftbmaterials:steel_ingot"
			}
		],
		results: [
			{
				count: 1,
				id: "ftbmaterials:steel_dust"
			}
		],
		time: 300
	});

	// ============================================================================================

	// New Motor Recipe
	event
		.shaped("oritech:motor", [" C ", "EDE", "EDE"], {
			C: "ftbmaterials:nickel_ingot",
			E: "ftbmaterials:bronze_ingot",
			D: "oritech:magnetic_coil"
		})
		.id("ftbevolution:oritech_motor");

	// New Coil Recipe
	event
		.shaped("4x oritech:magnetic_coil", ["EEE", "CCC", "EEE"], {
			C: "ftbmaterials:bronze_ingot",
			E: "#c:ingots/nickel"
		})
		.id("ftbevolution:oritech_coil");

	//Silicon Adjustments =========================================================================

	event.smelting("ae2:silicon", "oritech:raw_silicon").xp(0.5).id("ftbevolution:silicon_from_smelting_raw_silicon");
	event.blasting("ae2:silicon", "oritech:raw_silicon").xp(0.5).id("ftbevolution:silicon_from_blasting_raw_silicon");

	event.replaceInput(
		{ id: "minecraft:crafting/alloy/rawsilicon" },
		"ftbmaterials:quartz_dust",
		"#ftbevolution:quartz_dust"
	);

	// ===============================================================================================

	//Removing Oritech's Clumps from Meka's Ore Processing to avoid a possible Meka Progression Skip
	let clumps_removed_ids_from_mekanism = [
		[
			"mekanism:processing/iron/dirty_dust/from_clump",
			"ftbmaterials:iron_clump",
			"mekanism:clump_iron"
		],
		[
			"mekanism:processing/gold/dirty_dust/from_clump",
			"ftbmaterials:gold_clump",
			"mekanism:clump_gold"
		],
		[
			"mekanism:processing/copper/dirty_dust/from_clump",
			"ftbmaterials:copper_clump",
			"mekanism:clump_copper"
		]
	];

	clumps_removed_ids_from_mekanism.forEach((id) => {
		event.replaceInput({ id: id[0] }, id[1], id[2]);
	});

	//Adding a Particle Collision for Fargo's Energy
	event
		.custom({
			type: "oritech:particle_collision",
			fluidInput: {
				amount: 0,
				fluid: "minecraft:empty"
			},
			fluidOutput: {
				amount: 0,
				fluid: "minecraft:empty"
			},
			ingredients: [
				{
					item: "powah:nitro_crystal_block"
				},
				{
					item: "irons_spellbooks:energized_core"
				}
			],
			results: [
				{
					count: 9,
					id: "fargostalismans:abominable_energy"
				}
			],
			time: 1000
		})
		.id("ftbevolution:particle_collision/abominable_energy");

	//Unifying Clumps with FTB Materials Clumps
	let clump_unification = [
		["oritech:iron_clump", "ftbmaterials:iron_clump"],
		["oritech:copper_clump", "ftbmaterials:copper_clump"],
		["oritech:gold_clump", "ftbmaterials:gold_clump"],
		["oritech:platinum_clump", "ftbmaterials:platinum_clump"],
		["oritech:nickel_clump", "ftbmaterials:nickel_clump"]
	];

	clump_unification.forEach((id) => {
		event.replaceOutput({ id: id[0] }, id[0], id[1]);
	});

	//Fixing Clump Ore Processing Recipes ===========================================================
	//Wet should return 2 Gems
	//Dry should return 1 Gem and 3 Tiny Dusts
	//Acid should return 3 Gems and 250mb of Mineral Slurry

	let oritech_clump_to_gem_processing = [
		{
			material: "antimony",
			provider: "jaopca",
			tiny_dust: "modern_industrialization:antimony_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "azure_silver",
			provider: "jaopca",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "crimson_iron",
			provider: "jaopca",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "iesnium",
			provider: "jaopca",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "iridium",
			provider: "jaopca",
			tiny_dust: "modern_industrialization:iridium_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "lead",
			provider: "jaopca",
			tiny_dust: "modern_industrialization:lead_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "mithril",
			provider: "jaopca",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "osmium",
			provider: "jaopca",
			tiny_dust: "ftbmaterials:osmium_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "prosperity",
			provider: "jaopca",
			addDryRecipe: false,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "silver",
			provider: "jaopca",
			tiny_dust: "modern_industrialization:silver_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "soulium",
			provider: "jaopca",
			addDryRecipe: false,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "swamp_silver",
			provider: "jaopca",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "tin",
			provider: "jaopca",
			tiny_dust: "modern_industrialization:tin_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "zinc",
			provider: "jaopca",
			tiny_dust: "ftbmaterials:zinc_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "uranium",
			provider: "custom",
			gem: "ftbmaterials:uranium_dust",
			tiny_dust: "modern_industrialization:plutonium_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "iron",
			provider: "oritech",
			tiny_dust: "modern_industrialization:nickel_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "copper",
			provider: "oritech",
			tiny_dust: "modern_industrialization:gold_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "gold",
			provider: "oritech",
			tiny_dust: "modern_industrialization:copper_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "platinum",
			provider: "oritech",
			tiny_dust: "oritech:fluxite",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		},
		{
			material: "nickel",
			provider: "oritech",
			tiny_dust: "modern_industrialization:platinum_tiny_dust",
			addDryRecipe: true,
			addWetRecipe: true,
			addAcidRecipe: true,
			removeOriginals: true
		}
	];

	oritech_clump_to_gem_processing.forEach((recipe) => {

		let gem = "";
		let clump = `c:clumps/${recipe.material}`
		let tiny_dust = "";

		//Defining the Tiny Dusts, if its not specified, it is probably from JAOPCA
		if (recipe.tiny_dust) {
			tiny_dust = recipe.tiny_dust
		} else { tiny_dust = `jaopca:tiny_dusts.${recipe.material}` }

		switch (recipe.provider) {
			case "jaopca":
				gem = `jaopca:oritech_gems.${recipe.material}`
				break;

			case "oritech":
				gem = `oritech:${recipe.material}_gem`
				break;

			default:
				gem = recipe.gem
				break;
		}
		
		if (recipe.removeOriginals) {
			if (recipe.provider == "jaopca") {
				event.remove({
					id: `jaopca:oritech.clump_to_gem_dry.${recipe.material}`
				});
				event.remove({
					id: `jaopca:oritech.clump_to_gem_wet.${recipe.material}`
				});
				event.remove({
					id: `jaopca:oritech.clump_to_gem_acid.${recipe.material}`
				});
			} else {
				event.remove({
					id: `oritech:centrifuge/clump/${recipe.material}`
				});
				event.remove({
					id: `oritech:centrifuge/clumpdry/${recipe.material}`
				});
				event.remove({
					id: `oritech:centrifuge/fluid/clump/${recipe.material}`
				});
				event.remove({
					id: `oritech:centrifuge/fluid/clumpacid/${recipe.material}`
				});
			}
		}

		if (recipe.addWetRecipe) {
			event.custom({
				type: "oritech:centrifuge_fluid",
				fluidInput: {
					amount: 1000,
					fluid: "minecraft:water"
				},
				fluidOutput: {
					amount: 0,
					fluid: "minecraft:empty"
				},
				ingredients: [
					{
						tag: clump
					}
				],
				results: [
					{
						count: 2,
						id: gem
					}
				],
				time: 300
			}).id(`ftb:oritech/centrifuge/clumpwet/${recipe.material}`);
		}

		if (recipe.addAcidRecipe) {
			event.custom({
				type: "oritech:centrifuge_fluid",
				fluidInput: {
					amount: 1000,
					fluid: "modern_industrialization:sulfuric_acid"
				},
				fluidOutputs: [
					{
						amount: 250,
						fluid: "oritech:still_mineral_slurry"
					}
				],
				ingredients: [
					{
						tag: clump
					}
				],
				results: [
					{
						count: 3,
						id: gem
					}
				],
				time: 150
			}).id(`ftb:oritech/centrifuge/clumpacid/${recipe.material}`);
		}

		if (recipe.addDryRecipe) {
			event.custom({
				type: "oritech:centrifuge",
				fluidInput: {
					amount: 0,
					fluid: "minecraft:empty"
				},
				fluidOutput: {
					amount: 0,
					fluid: "minecraft:empty"
				},
				ingredients: [
					{
						tag: clump
					}
				],
				results: [
					{
						count: 1,
						id: gem
					},
					{
						count: 3,
						id: tiny_dust
					}
				],
				time: 200
			}).id(`oritech:centrifuge/clumpdry/${recipe.material}`);
		}
	});

	//Adding Coal Dust Recipes to Oritech Machines.
	event
		.custom({
			type: "oritech:pulverizer",
			fluidInput: {
				amount: 0,
				fluid: "minecraft:empty"
			},
			fluidOutput: {
				amount: 0,
				fluid: "minecraft:empty"
			},
			ingredients: [
				{
					item: "minecraft:coal"
				}
			],
			results: [
				{
					count: 1,
					id: "ftbmaterials:coal_dust"
				}
			],
			time: 200
		})
		.id(`ftb:oritech/pulverizer/coal_dust`);

	event
		.custom({
			type: "oritech:grinder",
			fluidInput: {
				amount: 0,
				fluid: "minecraft:empty"
			},
			fluidOutput: {
				amount: 0,
				fluid: "minecraft:empty"
			},
			ingredients: [
				{
					item: "minecraft:coal"
				}
			],
			results: [
				{
					count: 1,
					id: "ftbmaterials:coal_dust"
				}
			],
			time: 140
		})
		.id(`ftb:oritech/grinder/coal_dust`);

    //Adding a Convertion Recipe for Plutonium Dust
    event.shapeless(
        Item.of("modern_industrialization:plutonium_dust", 1),
       [
        "oritech:plutonium_dust"
       ]
   ).id("ftb:shapeless/plutonium_dust_convertion");

   //Manual Resin Recipe Unification Fix
   event.replaceInput({ id: "oritech:crafting/manualresin" }, "oritech:still_naphtha_bucket","modern_industrialization:naphtha_bucket");
   
   //Fixing Refinery Module Alt Recipe using the wrong Silicon.
   event.replaceInput({ id: "oritech:crafting/refinerymodulealt" }, "oritech:silicon","ae2:silicon");

});
