// priority: 964

ServerEvents.recipes((event) => {
  //vanilla Bookshelf == Oak Bookshelf (Fixes a Recipe Conflict)
  event.replaceInput(
    { id: "minecraft:bookshelf" },
    "#minecraft:planks",
    "#ftbevolution:vanilla_planks"
  );

  //Fixing the Vanilla Crafting Table Recipe
  event.replaceInput(
    { id: "minecraft:crafting_table" },
    "#minecraft:planks",
    "#ftbevolution:vanilla_planks"
  );
  event.shaped(
    Item.of("minecraft:crafting_table", 1), // arg 1: output
    ["PP", "PP"],
    {
      P: "#ftbevolution:productive_planks",
    }
  );

  //Fixing Pumpkin Pie Recipe (Now Allows more Pumpkin Types)
  event.replaceInput(
    { id: "minecraft:pumpkin_pie" },
    "biomeswevegone:pale_pumpkin",
    "#chipped:pumpkin"
  );

  //Improving the Dispenser Recipe (Now Accepts multiple types of Cobble)
  event.replaceInput(
    { id: "minecraft:dispenser" },
    '#c:cobblestones/normal',
    '#minecraft:stone_crafting_materials'
  );

  //Improving the Observer Recipe (Now Accepts multiple types of Cobble)
  event.replaceInput(
    { id: "minecraft:observer" },
    '#c:cobblestones/normal',
    '#minecraft:stone_crafting_materials'
  );

  //Improving the Piston Recipe (Now Accepts multiple types of Cobble)
  event.replaceInput(
    { id: "minecraft:piston" },
    '#c:cobblestones/normal',
    '#minecraft:stone_crafting_materials'
  );

  //Improving the Dropper Recipe (Now Accepts multiple types of Cobble)
  event.replaceInput(
    { id: "minecraft:dropper" },
    '#c:cobblestones/normal',
    '#minecraft:stone_crafting_materials'
  );

  //Improving the Lever Recipe (Now Accepts multiple types of Cobble and Sticks)
  event.replaceInput(
    { id: "minecraft:lever" },
    '#c:cobblestones/normal',
    '#minecraft:stone_crafting_materials'
  );
  event.replaceInput(
    { id: "minecraft:lever" },
    '#minecraft:stick',
    '#c:rods/wooden'
  );

  //Improving the Piston Recipe (Now Accepts multiple types of Combs)
  event.replaceInput(
    { id: "minecraft:beehive" },
    'minecraft:honeycomb',
    '#c:honeycombs'
  );

  //Improving the Sticky Piston Recipe (Now Accepts multiple types of Slime)
  event.replaceInput(
    { id: "minecraft:sticky_piston" },
    'minecraft:slime_ball',
    '#c:slime_balls'
  );

  //Improving the Lead Recipe (Now Accepts multiple types of Slime)
  event.replaceInput(
    { id: "minecraft:lead" },
    'minecraft:slime_ball',
    '#c:slime_balls'
  );

  //Improving the Cake Recipe (Now Accepts multiple types of Milk)
  event.replaceInput(
    { id: "minecraft:cake" },
    'minecraft:milk_bucket',
    '#c:foods/milk'
  );

  //Trying to Fix the Honey Block Recipe in AE2 (The Default Vanilla Recipe would always leave 1 honey bottle in the terminal for some reason)
  event.shapeless(
    Item.of("minecraft:honey_block"),
    ["minecraft:honey_bottle", "minecraft:honey_bottle", "minecraft:honey_bottle", "minecraft:honey_bottle"]
  ).id("ftbevolution:minecraft/honey_block");

  //Workaround until the Pillager Captain Loottable is fixed.
  event.shapeless(
    Item.of("minecraft:ominous_bottle"),
    [`minecraft:white_banner[banner_patterns=[{color:"cyan",pattern:"minecraft:rhombus"},{color:"light_gray",pattern:"minecraft:stripe_bottom"},{color:"gray",pattern:"minecraft:stripe_center"},{color:"light_gray",pattern:"minecraft:border"},{color:"black",pattern:"minecraft:stripe_middle"},{color:"light_gray",pattern:"minecraft:half_horizontal"},{color:"light_gray",pattern:"minecraft:circle"},{color:"black",pattern:"minecraft:border"}],hide_additional_tooltip={},item_name='{"color":"gold","translate":"block.minecraft.ominous_banner"}']`, 'minecraft:experience_bottle']
  ).id("ftbevolution:minecraft/ominous_bottle");

    //Adjusting Stick Recipe to not conflict with the Blackthorn Stick Recipe.
    event.replaceInput({ id: "minecraft:stick" }, "#minecraft:planks", "#ftb:non_blackthorn_planks");
    //Adjusting Stick Recipe to not conflict with the Blackthorn Stick Recipe.
    event.replaceInput({ id: "enderio:stick" }, "#minecraft:logs", "#ftb:non_blackthorn_logs");

});
