// priority: 963

ServerEvents.recipes((event) => {

    //Making Sure that all XyCraft Recipes use Xy's Aluminum

    let xycraft_recipe_ids = [
        "xycraft:shaped/machine_base",
        "xycraft:shaped/extractor",
        "xycraft:shaped/void_container",
        "xycraft:shapeless/port_fluid",
        "xycraft:shaped/foil",
        "xycraft:shaped/hydro_pump",
        "immersiveengineering:crafting/nugget_aluminum_to_ingot_aluminum"
    ];

    xycraft_recipe_ids.forEach(recipe => {
      event.replaceInput(
        { id: recipe },
        'ftbmaterials:aluminum_ingot',
        'xycraft_world:aluminum_ingot'
      )
      event.replaceInput(
        { id: recipe },
        'ftbmaterials:aluminum_nugget',
        'xycraft_world:aluminum_nugget'
      )
    });

    let xycraft_crystals = [
        ['xycraft_world:xychorium_ore_stone_blue', 'xycraft_world:xychorium_gem_blue'],
        ['xycraft_world:xychorium_ore_stone_green', 'xycraft_world:xychorium_gem_green'],
        ['xycraft_world:xychorium_ore_stone_red', 'xycraft_world:xychorium_gem_red'],
        ['xycraft_world:xychorium_ore_stone_dark', 'xycraft_world:xychorium_gem_dark'],
        ['xycraft_world:xychorium_ore_stone_light', 'xycraft_world:xychorium_gem_light'],

        ['xycraft_world:xychorium_ore_deepslate_blue', 'xycraft_world:xychorium_gem_blue'],
        ['xycraft_world:xychorium_ore_deepslate_green', 'xycraft_world:xychorium_gem_green'],
        ['xycraft_world:xychorium_ore_deepslate_red', 'xycraft_world:xychorium_gem_red'],
        ['xycraft_world:xychorium_ore_deepslate_dark', 'xycraft_world:xychorium_gem_dark'],
        ['xycraft_world:xychorium_ore_deepslate_light', 'xycraft_world:xychorium_gem_light']
    ];
    
    xycraft_crystals.forEach(crystal => {
        event.custom({"type":"mekanism:enriching","input":{"count":1,"item":crystal[0]},"output":{"count":2,"id":crystal[1]}})
        event.custom({
            "type": "integrateddynamics:squeezer",
            "input_item": {
              "item": crystal[0]
            },
            "output_items": [
              {
                "item": {
                  "count": 2,
                  "id": crystal[1]
                }
              },
              {
                "item": {
                  "id": crystal[1]
                },
                "chance": 0.5
              }
            ]
        })
        event.custom({
            "type": "integrateddynamics:mechanical_squeezer",
            "input_item": {
              "item": crystal[0]
            },
            "output_items": [
              {
                "item": {
                  "count": 2,
                  "id": crystal[1]
                }
              },
              {
                "item": {
                  "id": crystal[1]
                },
                "chance": 0.5
              }
            ],
            "duration": 30
        })
        event.custom({
          "type": "actuallyadditions:crushing",
          "ingredient": {
            "item": crystal[0]
          },
          "result": [
            {
              "result": {
                "count": 2,
                "id": crystal[1]
              }
            },
            {
              "chance": 0.5,
              "result": {
                "count": 1,
                "id": crystal[1]
              }
            }
          ]
        })

        //Editing the Alu Block Forced Recipe to not include MI's Alu.
        event.replaceInput(
          { id: 'xycraft:packing/aluminum_storage_forced' },
          'ftbmaterials:aluminum_ingot',
          'xycraft_world:aluminum_ingot'
        )

    })
});