// priority: 960

ServerEvents.recipes((event) => {
    
    //Improving Andesite Alloy Recipe by swapping to chipped:andesite
    event.replaceInput({ id: "create:crafting/materials/andesite_alloy" }, "minecraft:andesite", "#chipped:andesite");
    event.replaceInput({ id: "create:crafting/materials/andesite_alloy_from_zinc" }, "minecraft:andesite", "#chipped:andesite");

    //Apparently this Recipe also needs to be tweaked.
    event.replaceInput({ id: "georenouveau:zinc_geore_dowsing_rod" }, "create:zinc_ingot", "#c:ingots/zinc");

    //Adding Blasting and Smelting Recipes for materials that don't have them =====================
    
    let create_crushed_blasting = [
        ["create:crushed_raw_nickel", "ftbmaterials:nickel_ingot"], 
        ["create:crushed_raw_aluminum", "xycraft_world:aluminum_ingot"], 
        ["create:crushed_raw_platinum", "modern_industrialization:platinum_hot_ingot"],
        ["create:crushed_raw_silver", "ftbmaterials:silver_ingot"],
        ["create:crushed_raw_tin", "ftbmaterials:tin_ingot"],
        ["create:crushed_raw_osmium", "ftbmaterials:osmium_ingot"],
        ["create:crushed_raw_lead", "ftbmaterials:lead_ingot"],
        ["create:crushed_raw_uranium", "ftbmaterials:uranium_ingot"],
        ["create:crushed_raw_zinc", "ftbmaterials:zinc_ingot"],
    ];

    create_crushed_blasting.forEach(crushed_ore => {

        let output_name = crushed_ore[1].split(":")[1]
        let input_name = crushed_ore[0].split(":")[1]

        event.custom({
            "type": "minecraft:blasting",
            "category": "misc",
            "cookingtime": 100,
            "experience": 0.1,
            "ingredient": {
              "item": crushed_ore[0]
            },
            "result": {
              "count": 1,
              "id": crushed_ore[1]
            }
        }).id("ftb:blasting/" + input_name + "_to_" + output_name)

        event.smelting(crushed_ore[1], crushed_ore[0]).id("ftb:smelting/" + input_name + "_to_" + output_name)

    });

    // ============================================================================================

    //Adding Washing Recipes for materials that don't have them ==================================

    let create_crushed_washing = [
      //Nickel
      {
        input: "create:crushed_raw_nickel",
        main_output: "ftbmaterials:nickel_nugget",
        main_output_count: 9,
        secondary_output: "ftbmaterials:nickel_nugget",
        secondary_output_chance: 0.25,
        secondary_output_count: 1
      },
      //Aluminum
      {
        input: "create:crushed_raw_aluminum",
        main_output: "xycraft_world:aluminum_nugget",
        main_output_count: 9,
        secondary_output: "xycraft_world:aluminum_nugget",
        secondary_output_chance: 0.25,
        secondary_output_count: 1
      },
      //Silver
      {
        input: "create:crushed_raw_silver",
        main_output: "ftbmaterials:silver_nugget",
        main_output_count: 9,
        secondary_output: "ftbmaterials:silver_nugget",
        secondary_output_chance: 0.25,
        secondary_output_count: 1
      },
      //Osmium
      {
        input: "create:crushed_raw_osmium",
        main_output: "ftbmaterials:osmium_nugget",
        main_output_count: 9,
        secondary_output: "ftbmaterials:osmium_nugget",
        secondary_output_chance: 0.25,
        secondary_output_count: 1
      },
      //Platinum (Disabled due to MI's Balance)
      // {
      //   input: "create:crushed_raw_platinum",
      //   main_output: "ftbmaterials:platinum_nugget",
      //   main_output_count: 9,
      //   secondary_output: "oritech:fluxite",
      //   secondary_output_chance: 0.25,
      //   secondary_output_count: 1
      // },
      //Tin
      {
        input: "create:crushed_raw_tin",
        main_output: "ftbmaterials:tin_nugget",
        main_output_count: 9,
        secondary_output: "ftbmaterials:tin_nugget",
        secondary_output_chance: 0.25,
        secondary_output_count: 1
      },
      //Copper
      {
        input: "create:crushed_raw_copper",
        main_output: "ftbmaterials:copper_nugget",
        main_output_count: 9,
        secondary_output: "modern_industrialization:gold_tiny_dust",
        secondary_output_chance: 0.50,
        secondary_output_count: 2
      },
      //Lead
      {
        input: "create:crushed_raw_lead",
        main_output: "ftbmaterials:lead_nugget",
        main_output_count: 9,
        secondary_output: "ftbmaterials:lead_nugget",
        secondary_output_chance: 0.25,
        secondary_output_count: 1
      },
      //Uranium
      {
        input: "create:crushed_raw_uranium",
        main_output: "ftbmaterials:uranium_nugget",
        main_output_count: 9,
        secondary_output: "modern_industrialization:plutonium_tiny_dust",
        secondary_output_chance: 0.25,
        secondary_output_count: 1
      }
    ];

    create_crushed_washing.forEach(recipe => {

        let output_name = recipe.main_output.split(":")[1]
        let input_name = recipe.input.split(":")[1]

        event.custom({
            "type": "create:splashing",
            "ingredients": [
              {
                "item": recipe.input
              }
            ],
            "results": [
              {
                "count": recipe.main_output_count,
                "item": {
                  "id": recipe.main_output
                }
              },
              {
                "chance": recipe.secondary_output_chance,
                "count": recipe.secondary_output_count,
                "item": {
                  "id": recipe.secondary_output
                }
              }
            ]
          }).id("ftb:washing/" + input_name + "_to_" + output_name)
    });

    // ============================================================================================

    //Adding Recipes for Create's Enchantments to the EnderIO Enchanter ===========================

    //Potato Recovery
    event.custom({
      "type": "enderio:enchanting",
      "cost_multiplier": 1,
      "enchantment": "create:potato_recovery",
      "input": {
        "count": 2,
        "item": "farmersdelight:potato_crate"
      }
    }).id("ftb:enderio/enchanting/create/potato_recovery");

    //Air Capacity
    event.custom({
      "type": "enderio:enchanting",
      "cost_multiplier": 1,
      "enchantment": "create:capacity",
      "input": {
        "count": 2,
        "item": "create:fluid_tank"
      }
    }).id("ftb:enderio/enchanting/create/capacity");

  // ==============================================================================================

  //Adding a Infusing Recipe for Rose Quartz
  event.custom({
    "type": "mekanism:metallurgic_infusing",
    "chemical_input": {
      "amount": 60,
      "tag": "mekanism:redstone"
    },
    "item_input": {
      "count": 1,
      "tag": "ae2:all_quartz"
    },
    "output": {
      "count": 1,
      "id": "create:rose_quartz"
    },
    "per_tick_usage": false
  }).id("ftb:mekanism/metallurgic_infusing/create/rose_quartz");

  //Fixing Flour Unification
  event.replaceInput({ id: "farmersdelight:integration/create/mixing/pie_crust_from_mixing" }, "create:wheat_flour", "#c:flours/wheat");

});