// priority: 956

ServerEvents.recipes((event) => {

    //Making Better Quartz Enriched Alloying Recipes ==============================================

    //Quartz Enriched Iron
    event.custom({
        "type": "enderio:alloy_smelting",
        "energy": 2000,
        "experience": 0.3,
        "inputs": [
          {
            "count": 3,
            "item": "minecraft:iron_ingot"
          },
          {
            "count": 1,
            "tag": "ae2:all_quartz"
          }
        ],
        "output": {
          "count": 4,
          "id": "refinedstorage:quartz_enriched_iron"
        }
    }).id("ftb:refinedstorage/enderio/alloying/quartz_enriched_iron");

    event.custom({
        "type": "create:mixing",
        "heat_requirement": "heated",
        "ingredients": [
          {
            "tag": "c:ingots/iron"
          },
          {
            "tag": "c:ingots/iron"
          },
          {
            "tag": "c:ingots/iron"
          },
          {
            "tag": "ae2:all_quartz"
          }
        ],
        "results": [
          {
            "count": 4,
            "item": {
              "id": "refinedstorage:quartz_enriched_iron"
            }
          }
        ]
      }).id("ftb:refinedstorage/create/mixing/quartz_enriched_iron");

      event.custom({
        type: "extended_industrialization:alloy_smelter",
        eu: 4,
        duration: 200,
        item_inputs: [
          {
            tag: "ae2:all_quartz",
            amount: 1,
          },        {
            tag: "c:ingots/iron",
            amount: 3,
          }
        ],
        item_outputs: [
          {
            item: "refinedstorage:quartz_enriched_iron",
            amount: 4,
          },
        ],
      }).id("ftb:refinedstorage/extended_industrialization/alloy_smelter/quartz_enriched_iron");

      event.custom({
        "type": "immersiveengineering:alloy",
        "input0": {
          "basePredicate": {
            "tag": "c:ingots/iron"
          },
          "count": 3
        },
        "input1": {
          "tag": "ae2:all_quartz"
        },
        "result": {
          "basePredicate": {
            "item": "refinedstorage:quartz_enriched_iron"
          },
          "count": 4
        }
      }).id("ftb:refinedstorage/immersiveengineering/alloy/quartz_enriched_iron");

      event.custom({
        "type": "immersiveengineering:arc_furnace",
        "additives": [
          {
            "tag": "ae2:all_quartz"
          }
        ],
        "energy": 51200,
        "input": {
          "basePredicate": {
            "tag": "c:ingots/iron"
          },
          "count": 3
        },
        "results": [
          {
            "basePredicate": {
                "item": "refinedstorage:quartz_enriched_iron"
            },
            "count": 4
          }
        ],
        "time": 100
      }).id("ftb:refinedstorage/immersiveengineering/arc_furnace/quartz_enriched_iron");

    //Quartz Enriched Copper
    event.custom({
        "type": "enderio:alloy_smelting",
        "energy": 2000,
        "experience": 0.3,
        "inputs": [
          {
            "count": 3,
            "item": "minecraft:copper_ingot"
          },
          {
            "count": 1,
            "tag": "ae2:all_quartz"
          }
        ],
        "output": {
          "count": 4,
          "id": "refinedstorage:quartz_enriched_copper"
        }
    }).id("ftb:refinedstorage/enderio/alloying/quartz_enriched_copper");

    event.custom({
        "type": "create:mixing",
        "heat_requirement": "heated",
        "ingredients": [
          {
            "tag": "c:ingots/copper"
          },
          {
            "tag": "c:ingots/copper"
          },
          {
            "tag": "c:ingots/copper"
          },
          {
            "tag": "ae2:all_quartz"
          }
        ],
        "results": [
          {
            "count": 4,
            "item": {
              "id": "refinedstorage:quartz_enriched_copper"
            }
          }
        ]
      }).id("ftb:refinedstorage/create/mixing/quartz_enriched_copper");

      event.custom({
        type: "extended_industrialization:alloy_smelter",
        eu: 4,
        duration: 200,
        item_inputs: [
          {
            tag: "ae2:all_quartz",
            amount: 1,
          },        {
            tag: "c:ingots/copper",
            amount: 3,
          }
        ],
        item_outputs: [
          {
            item: "refinedstorage:quartz_enriched_copper",
            amount: 4,
          },
        ],
      }).id("ftb:refinedstorage/extended_industrialization/alloy_smelter/quartz_enriched_copper");

      event.custom({
        "type": "immersiveengineering:alloy",
        "input0": {
          "basePredicate": {
            "tag": "c:ingots/copper"
          },
          "count": 3
        },
        "input1": {
          "tag": "ae2:all_quartz"
        },
        "result": {
          "basePredicate": {
            "item": "refinedstorage:quartz_enriched_copper"
          },
          "count": 4
        }
      }).id("ftb:refinedstorage/immersiveengineering/alloy/quartz_enriched_copper");
      
      event.custom({
        "type": "immersiveengineering:arc_furnace",
        "additives": [
          {
            "tag": "ae2:all_quartz"
          }
        ],
        "energy": 51200,
        "input": {
          "basePredicate": {
            "tag": "c:ingots/copper"
          },
          "count": 3
        },
        "results": [
          {
            "basePredicate": {
                "item": "refinedstorage:quartz_enriched_copper"
            },
            "count": 4
          }
        ],
        "time": 100
      }).id("ftb:refinedstorage/immersiveengineering/arc_furnace/quartz_enriched_copper");
      
    // ============================================================================================

    //Replacing Osmium in Recipes that don't use Tags.

    let osmium_replacement_ids = [
      "mekanism_lasers:advanced_toggleable_laser_2",
      "refinedstorage_mekanism_integration:64b_chemical_storage_disk",
      "refinedstorage_mekanism_integration:256b_chemical_storage_disk",
      "refinedstorage_mekanism_integration:1024b_chemical_storage_disk",
      "refinedstorage_mekanism_integration:8192b_chemical_storage_disk",
      "refinedstorage_mekanism_integration:64b_chemical_storage_block",
      "refinedstorage_mekanism_integration:256b_chemical_storage_block",
      "refinedstorage_mekanism_integration:1024b_chemical_storage_block",
      "refinedstorage_mekanism_integration:8192b_chemical_storage_block",
      "refinedstorage_mekanism_integration:64b_chemical_storage_part",
      "refinedstorage_mekanism_integration:256b_chemical_storage_part",
      "refinedstorage_mekanism_integration:1024b_chemical_storage_part",
      "refinedstorage_mekanism_integration:8192b_chemical_storage_part"
    ];

    osmium_replacement_ids.forEach(recipe => {
      event.replaceInput(
        { id: recipe },
        "mekanism:ingot_osmium",
        "#c:ingots/osmium"
      );
    });
    
});